/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.grpc.GrpcUtils;
import alluxio.network.TieredIdentityFactory;
import alluxio.util.CommonUtils;
import alluxio.util.TieredIdentityUtils;
import alluxio.wire.TieredIdentity;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TieredIdentityTest {
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();

    @Before
    public void before() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void nearest() throws Exception {
        TieredIdentity id1 = TieredIdentityFactory.fromString((String)"node=A,rack=rack1", (AlluxioConfiguration)this.mConfiguration);
        TieredIdentity id2 = TieredIdentityFactory.fromString((String)"node=B,rack=rack2", (AlluxioConfiguration)this.mConfiguration);
        TieredIdentity id3 = TieredIdentityFactory.fromString((String)"node=C,rack=rack2", (AlluxioConfiguration)this.mConfiguration);
        List<TieredIdentity> identities = Arrays.asList(id1, id2, id3);
        Assert.assertSame((Object)id1, TieredIdentityUtils.nearest((TieredIdentity)TieredIdentityFactory.fromString((String)"node=D,rack=rack1", (AlluxioConfiguration)this.mConfiguration), identities, (AlluxioConfiguration)this.mConfiguration).get());
        Assert.assertSame((Object)id2, TieredIdentityUtils.nearest((TieredIdentity)TieredIdentityFactory.fromString((String)"node=B,rack=rack2", (AlluxioConfiguration)this.mConfiguration), identities, (AlluxioConfiguration)this.mConfiguration).get());
        Assert.assertSame((Object)id3, TieredIdentityUtils.nearest((TieredIdentity)TieredIdentityFactory.fromString((String)"node=C,rack=rack2", (AlluxioConfiguration)this.mConfiguration), identities, (AlluxioConfiguration)this.mConfiguration).get());
        Assert.assertSame((Object)id1, TieredIdentityUtils.nearest((TieredIdentity)TieredIdentityFactory.fromString((String)"node=D,rack=rack3", (AlluxioConfiguration)this.mConfiguration), identities, (AlluxioConfiguration)this.mConfiguration).get());
    }

    @Test
    public void json() throws Exception {
        TieredIdentity tieredIdentity = TieredIdentityTest.createRandomTieredIdentity();
        ObjectMapper mapper = new ObjectMapper();
        TieredIdentity other = (TieredIdentity)mapper.readValue(mapper.writeValueAsBytes((Object)tieredIdentity), TieredIdentity.class);
        this.checkEquality(tieredIdentity, other);
    }

    @Test
    public void proto() {
        TieredIdentity tieredIdentity = TieredIdentityTest.createRandomTieredIdentity();
        TieredIdentity other = GrpcUtils.fromProto((alluxio.grpc.TieredIdentity)GrpcUtils.toProto((TieredIdentity)tieredIdentity));
        this.checkEquality(tieredIdentity, other);
    }

    @Test
    public void matchByStringEquality() {
        TieredIdentity.LocalityTier lt1 = new TieredIdentity.LocalityTier("node", "NonResolvableHostname-A");
        TieredIdentity.LocalityTier lt2 = new TieredIdentity.LocalityTier("node", "NonResolvableHostname-A");
        TieredIdentity.LocalityTier lt3 = new TieredIdentity.LocalityTier("node", "NonResolvableHostname-B");
        TieredIdentity.LocalityTier lt4 = new TieredIdentity.LocalityTier("rack", "NonResolvableHostname-A");
        TieredIdentity.LocalityTier lt5 = new TieredIdentity.LocalityTier("rack", "NonResolvableHostname-B");
        TieredIdentity.LocalityTier lt6 = new TieredIdentity.LocalityTier("rack", "NonResolvableHostname-B");
        TieredIdentity.LocalityTier lt7 = new TieredIdentity.LocalityTier("rack", "");
        TieredIdentity.LocalityTier lt8 = new TieredIdentity.LocalityTier("node", "NonResolvableHostname-A");
        TieredIdentity.LocalityTier lt9 = new TieredIdentity.LocalityTier("node", "");
        Assert.assertTrue((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt1, (TieredIdentity.LocalityTier)lt1, (boolean)true));
        Assert.assertTrue((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt1, (TieredIdentity.LocalityTier)lt2, (boolean)true));
        Assert.assertFalse((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt2, (TieredIdentity.LocalityTier)lt3, (boolean)true));
        Assert.assertTrue((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt5, (TieredIdentity.LocalityTier)lt6, (boolean)true));
        Assert.assertFalse((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt4, (TieredIdentity.LocalityTier)lt5, (boolean)true));
        Assert.assertFalse((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt6, (TieredIdentity.LocalityTier)lt7, (boolean)true));
        Assert.assertFalse((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt8, (TieredIdentity.LocalityTier)lt9, (boolean)true));
    }

    @Test
    public void matchByIpResolution() throws Exception {
        Assume.assumeTrue((boolean)InetAddress.getByName("localhost").getHostAddress().equals("127.0.0.1"));
        TieredIdentity.LocalityTier lt1 = new TieredIdentity.LocalityTier("node", "localhost");
        TieredIdentity.LocalityTier lt2 = new TieredIdentity.LocalityTier("node", "127.0.0.1");
        Assert.assertTrue((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt1, (TieredIdentity.LocalityTier)lt2, (boolean)true));
        Assert.assertFalse((boolean)TieredIdentityUtils.matches((TieredIdentity.LocalityTier)lt1, (TieredIdentity.LocalityTier)lt2, (boolean)false));
    }

    public void string() {
        TieredIdentity identity = new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("k1", "v1"), new TieredIdentity.LocalityTier("k2", "v2")));
        Assert.assertEquals((Object)"TieredIdentity(k1=v1, k2=v2)", (Object)identity.toString());
    }

    public void checkEquality(TieredIdentity a, TieredIdentity b) {
        Assert.assertEquals((Object)a.getTiers(), (Object)b.getTiers());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static TieredIdentity createRandomTieredIdentity() {
        return new TieredIdentity(Arrays.asList(TieredIdentityTest.createRandomLocalityTier(), TieredIdentityTest.createRandomLocalityTier()));
    }

    private static TieredIdentity.LocalityTier createRandomLocalityTier() {
        Random random = new Random();
        String tier = CommonUtils.randomAlphaNumString((int)(random.nextInt(10) + 1));
        String value = CommonUtils.randomAlphaNumString((int)(random.nextInt(10) + 1));
        return new TieredIdentity.LocalityTier(tier, value);
    }
}

