/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.util.CommonUtils;
import alluxio.wire.MountPointInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MountPointInfoTest {
    @Test
    public void json() throws Exception {
        MountPointInfo mountPointInfo = MountPointInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        MountPointInfo other = (MountPointInfo)mapper.readValue(mapper.writeValueAsBytes((Object)mountPointInfo), MountPointInfo.class);
        this.checkEquality(mountPointInfo, other);
    }

    @Test
    public void proto() {
        MountPointInfo mountPointInfo = MountPointInfoTest.createRandom();
        MountPointInfo other = GrpcUtils.fromProto((alluxio.grpc.MountPointInfo)GrpcUtils.toProto((MountPointInfo)mountPointInfo));
        this.checkEquality(mountPointInfo, other);
    }

    public void checkEquality(MountPointInfo a, MountPointInfo b) {
        Assert.assertEquals((Object)a.getUfsUri(), (Object)b.getUfsUri());
        Assert.assertEquals((Object)a.getUfsType(), (Object)b.getUfsType());
        Assert.assertEquals((long)a.getUfsCapacityBytes(), (long)b.getUfsCapacityBytes());
        Assert.assertEquals((long)a.getUfsUsedBytes(), (long)b.getUfsUsedBytes());
        Assert.assertEquals((Object)a.getReadOnly(), (Object)b.getReadOnly());
        Assert.assertEquals((Object)a.getProperties(), (Object)b.getProperties());
        Assert.assertEquals((long)a.getMountId(), (long)b.getMountId());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static MountPointInfo createRandom() {
        Random random = new Random();
        String ufsUri = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String ufsType = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        long ufsCapacityBytes = random.nextLong();
        long ufsUsedBytes = random.nextLong();
        long mountId = random.nextLong();
        boolean readOnly = random.nextBoolean();
        HashMap<String, String> properties = new HashMap<String, String>();
        int n = random.nextInt(10) + 1;
        for (int i = 0; i < n; ++i) {
            properties.put(CommonUtils.randomAlphaNumString((int)random.nextInt(5)), CommonUtils.randomAlphaNumString((int)random.nextInt(5)));
        }
        MountPointInfo result = new MountPointInfo();
        result.setUfsUri(ufsUri);
        result.setUfsType(ufsType);
        result.setUfsCapacityBytes(ufsCapacityBytes);
        result.setUfsUsedBytes(ufsUsedBytes);
        result.setReadOnly(readOnly);
        result.setProperties(properties);
        result.setMountId(mountId);
        return result;
    }
}

