/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.InconsistentProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

public class InconsistentPropertyTest {
    @Test
    public void proto() {
        InconsistentProperty inconsistentProperty = InconsistentPropertyTest.createInconsistentProperty();
        InconsistentProperty other = InconsistentProperty.fromProto((alluxio.grpc.InconsistentProperty)inconsistentProperty.toProto());
        this.checkEquality(inconsistentProperty, other);
    }

    @Test
    public void testToString() {
        InconsistentProperty inconsistentProperty = InconsistentPropertyTest.createInconsistentProperty();
        String result = inconsistentProperty.toString();
        Assert.assertFalse((boolean)result.contains("Optional"));
        String expected = "InconsistentProperty{key=my_key, values=no value set (workerHostname1:workerPort, workerHostname2:workerPort), some_value (masterHostname1:port, masterHostname2:port)}";
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private static InconsistentProperty createInconsistentProperty() {
        HashMap<Optional<Object>, List<String>> values = new HashMap<Optional<Object>, List<String>>();
        values.put(Optional.ofNullable(null), Arrays.asList("workerHostname1:workerPort", "workerHostname2:workerPort"));
        values.put(Optional.of("some_value"), Arrays.asList("masterHostname1:port", "masterHostname2:port"));
        return new InconsistentProperty().setName("my_key").setValues(values);
    }

    private void checkEquality(InconsistentProperty a, InconsistentProperty b) {
        Assert.assertEquals((Object)a.getName(), (Object)b.getName());
        Assert.assertEquals((Object)a.getValues(), (Object)b.getValues());
        Assert.assertEquals((Object)a, (Object)b);
    }
}

