/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.grpc.TtlAction;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.util.CommonUtils;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileBlockInfoTest;
import alluxio.wire.FileInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class FileInfoTest {
    @Test
    public void javaSerialization() throws Exception {
        FileInfo fileInfo = FileInfoTest.createRandom();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new ObjectOutputStream(byteArrayOutputStream).writeObject(fileInfo);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        FileInfo newFileInfo = (FileInfo)new ObjectInputStream(byteArrayInputStream).readObject();
        this.checkEquality(fileInfo, newFileInfo);
    }

    @Test
    public void json() throws Exception {
        FileInfo fileInfo = FileInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        String s = mapper.writeValueAsString((Object)fileInfo);
        FileInfo other = (FileInfo)mapper.readValue(mapper.writeValueAsBytes((Object)fileInfo), FileInfo.class);
        this.checkEquality(fileInfo, other);
    }

    @Test
    public void proto() {
        FileInfo fileInfo = FileInfoTest.createRandom();
        FileInfo other = GrpcUtils.fromProto((alluxio.grpc.FileInfo)GrpcUtils.toProto((FileInfo)fileInfo));
        this.checkEquality(fileInfo, other);
    }

    public void checkEquality(FileInfo a, FileInfo b) {
        Assert.assertEquals((Object)a.getBlockIds(), (Object)b.getBlockIds());
        Assert.assertEquals((long)a.getBlockSizeBytes(), (long)b.getBlockSizeBytes());
        Assert.assertEquals((long)a.getCreationTimeMs(), (long)b.getCreationTimeMs());
        Assert.assertEquals((Object)a.getFileBlockInfos(), (Object)b.getFileBlockInfos());
        Assert.assertEquals((long)a.getFileId(), (long)b.getFileId());
        Assert.assertEquals((Object)a.getGroup(), (Object)b.getGroup());
        Assert.assertEquals((long)a.getLastModificationTimeMs(), (long)b.getLastModificationTimeMs());
        Assert.assertEquals((long)a.getLastAccessTimeMs(), (long)b.getLastAccessTimeMs());
        Assert.assertEquals((long)a.getLength(), (long)b.getLength());
        Assert.assertEquals((long)a.getMode(), (long)b.getMode());
        Assert.assertEquals((Object)a.getName(), (Object)b.getName());
        Assert.assertEquals((Object)a.getOwner(), (Object)b.getOwner());
        Assert.assertEquals((Object)a.getPath(), (Object)b.getPath());
        Assert.assertEquals((Object)a.getPersistenceState(), (Object)b.getPersistenceState());
        Assert.assertEquals((long)a.getTtl(), (long)b.getTtl());
        Assert.assertEquals((Object)a.getTtlAction(), (Object)b.getTtlAction());
        Assert.assertEquals((long)a.getMountId(), (long)b.getMountId());
        Assert.assertEquals((Object)a.getUfsPath(), (Object)b.getUfsPath());
        Assert.assertEquals((Object)a.isCacheable(), (Object)b.isCacheable());
        Assert.assertEquals((Object)a.isCompleted(), (Object)b.isCompleted());
        Assert.assertEquals((Object)a.isFolder(), (Object)b.isFolder());
        Assert.assertEquals((Object)a.isMountPoint(), (Object)b.isMountPoint());
        Assert.assertEquals((Object)a.isPersisted(), (Object)b.isPersisted());
        Assert.assertEquals((Object)a.isPinned(), (Object)b.isPinned());
        Assert.assertEquals((long)a.getInAlluxioPercentage(), (long)b.getInAlluxioPercentage());
        Assert.assertEquals((Object)a.getAcl(), (Object)b.getAcl());
        Assert.assertEquals((Object)a.getDefaultAcl(), (Object)b.getDefaultAcl());
        Assert.assertEquals((Object)a.getUfsFingerprint(), (Object)b.getUfsFingerprint());
        Assert.assertEquals((long)a.getReplicationMax(), (long)b.getReplicationMax());
        Assert.assertEquals((long)a.getReplicationMin(), (long)b.getReplicationMin());
        Assert.assertEquals((long)a.getXAttr().size(), (long)b.getXAttr().size());
        for (Map.Entry entry : a.getXAttr().entrySet()) {
            Assert.assertArrayEquals((byte[])((byte[])entry.getValue()), (byte[])((byte[])b.getXAttr().get(entry.getKey())));
        }
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static FileInfo createRandom() {
        FileInfo result = new FileInfo();
        Random random = new Random();
        long fileId = random.nextLong();
        String name = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String path = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String ufsPath = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        long mountId = random.nextLong();
        long length = random.nextLong();
        long blockSizeBytes = random.nextLong();
        long creationTimeMs = random.nextLong();
        boolean completed = random.nextBoolean();
        boolean folder = random.nextBoolean();
        boolean pinned = random.nextBoolean();
        boolean cacheable = random.nextBoolean();
        boolean persisted = random.nextBoolean();
        ArrayList<Long> blockIds = new ArrayList<Long>();
        long numBlockIds = random.nextInt(10);
        int i = 0;
        while ((long)i < numBlockIds) {
            blockIds.add(random.nextLong());
            ++i;
        }
        int inMemoryPercentage = random.nextInt();
        int inAlluxioPercentage = random.nextInt();
        long lastModificationTimeMs = random.nextLong();
        long lastAccessTimeMs = random.nextLong();
        long ttl = random.nextLong();
        String userName = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String groupName = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        int permission = random.nextInt();
        String persistenceState = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        boolean mountPoint = random.nextBoolean();
        ArrayList<FileBlockInfo> fileBlocksInfos = new ArrayList<FileBlockInfo>();
        long numFileBlockInfos = random.nextInt(10);
        int i2 = 0;
        while ((long)i2 < numFileBlockInfos) {
            fileBlocksInfos.add(FileBlockInfoTest.createRandom());
            ++i2;
        }
        int replicationMax = random.nextInt(10);
        int replicationMin = random.nextInt(10);
        HashMap<String, byte[]> xttrs = new HashMap<String, byte[]>();
        for (int i3 = 0; i3 < random.nextInt(10); ++i3) {
            xttrs.put(CommonUtils.randomAlphaNumString((int)random.nextInt(10)), CommonUtils.randomBytes((int)random.nextInt(10)));
        }
        result.setBlockIds(blockIds);
        result.setBlockSizeBytes(blockSizeBytes);
        result.setCacheable(cacheable);
        result.setCompleted(completed);
        result.setCreationTimeMs(creationTimeMs);
        result.setFileBlockInfos(fileBlocksInfos);
        result.setFileId(fileId);
        result.setFolder(folder);
        result.setGroup(groupName);
        result.setInMemoryPercentage(inMemoryPercentage);
        result.setLastModificationTimeMs(lastModificationTimeMs);
        result.setLastAccessTimeMs(lastAccessTimeMs);
        result.setLength(length);
        result.setMode(permission);
        result.setMountPoint(mountPoint);
        result.setReplicationMax(replicationMax);
        result.setReplicationMin(replicationMin);
        result.setName(name);
        result.setOwner(userName);
        result.setPath(path);
        result.setPersisted(persisted);
        result.setPersistenceState(persistenceState);
        result.setPinned(pinned);
        result.setTtl(ttl);
        result.setTtlAction(TtlAction.DELETE);
        result.setMountId(mountId);
        result.setUfsPath(ufsPath);
        result.setInAlluxioPercentage(inAlluxioPercentage);
        List<String> stringEntries = Arrays.asList("user::rw-", "group::r--", "other::rwx");
        AccessControlList acl = AccessControlList.fromStringEntries((String)userName, (String)groupName, stringEntries);
        result.setAcl(acl);
        List<String> defaultStringEntries = Arrays.asList("default:user::rw-", "default:group::r--", "default:other::rwx");
        result.setDefaultAcl((DefaultAccessControlList)AccessControlList.fromStringEntries((String)userName, (String)groupName, defaultStringEntries));
        result.setXAttr(xttrs);
        return result;
    }
}

