/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.util.CommonUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockInfoTest;
import alluxio.wire.FileBlockInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.net.HostAndPort;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class FileBlockInfoTest {
    @Test
    public void json() throws Exception {
        FileBlockInfo fileBlockInfo = FileBlockInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        FileBlockInfo other = (FileBlockInfo)mapper.readValue(mapper.writeValueAsBytes((Object)fileBlockInfo), FileBlockInfo.class);
        this.checkEquality(fileBlockInfo, other);
    }

    @Test
    public void proto() {
        FileBlockInfo fileBlockInfo = FileBlockInfoTest.createRandom();
        FileBlockInfo other = GrpcUtils.fromProto((alluxio.grpc.FileBlockInfo)GrpcUtils.toProto((FileBlockInfo)fileBlockInfo));
        this.checkEquality(fileBlockInfo, other);
    }

    public void checkEquality(FileBlockInfo a, FileBlockInfo b) {
        Assert.assertEquals((Object)a.getBlockInfo(), (Object)b.getBlockInfo());
        Assert.assertEquals((long)a.getOffset(), (long)b.getOffset());
        Assert.assertEquals((Object)a.getUfsLocations(), (Object)b.getUfsLocations());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static FileBlockInfo createRandom() {
        FileBlockInfo result = new FileBlockInfo();
        Random random = new Random();
        BlockInfo blockInfo = BlockInfoTest.createRandom();
        long offset = random.nextLong();
        ArrayList<String> ufsLocations = new ArrayList<String>();
        long numUfsLocations = random.nextInt(10);
        int i = 0;
        while ((long)i < numUfsLocations) {
            ufsLocations.add(HostAndPort.fromParts((String)CommonUtils.randomAlphaNumString((int)random.nextInt(10)), (int)random.nextInt(65535)).toString());
            ++i;
        }
        result.setBlockInfo(blockInfo);
        result.setOffset(offset);
        result.setUfsLocations(ufsLocations);
        return result;
    }
}

