/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.test.util.CommonUtils;
import alluxio.wire.AlluxioMasterInfo;
import alluxio.wire.Capacity;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class CapacityTest {
    @Test
    public void json() throws Exception {
        Capacity capacity = CapacityTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        Capacity other = (Capacity)mapper.readValue(mapper.writeValueAsBytes((Object)capacity), Capacity.class);
        this.checkEquality(capacity, other);
    }

    @Test
    public void equals() {
        CommonUtils.testEquals(AlluxioMasterInfo.class, new String[0]);
    }

    private void checkEquality(Capacity a, Capacity b) {
        Assert.assertEquals((long)a.getTotal(), (long)b.getTotal());
        Assert.assertEquals((long)a.getUsed(), (long)b.getUsed());
        Assert.assertEquals((Object)a, (Object)b);
    }

    protected static Capacity createRandom() {
        Capacity result = new Capacity();
        Random random = new Random();
        long total = random.nextLong();
        long used = random.nextLong();
        result.setTotal(total);
        result.setUsed(used);
        return result;
    }
}

