/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.BlockMasterInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class BlockMasterInfoTest {
    @Test
    public void json() throws Exception {
        BlockMasterInfo blockMasterInfo = BlockMasterInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        BlockMasterInfo other = (BlockMasterInfo)mapper.readValue(mapper.writeValueAsBytes((Object)blockMasterInfo), BlockMasterInfo.class);
        this.checkEquality(blockMasterInfo, other);
    }

    @Test
    public void proto() {
        BlockMasterInfo blockMasterInfo = BlockMasterInfoTest.createRandom();
        BlockMasterInfo other = BlockMasterInfo.fromProto((alluxio.grpc.BlockMasterInfo)blockMasterInfo.toProto());
        this.checkEquality(blockMasterInfo, other);
    }

    public void checkEquality(BlockMasterInfo a, BlockMasterInfo b) {
        Assert.assertEquals((long)a.getCapacityBytes(), (long)b.getCapacityBytes());
        Assert.assertEquals((Object)a.getCapacityBytesOnTiers(), (Object)b.getCapacityBytesOnTiers());
        Assert.assertEquals((long)a.getFreeBytes(), (long)b.getFreeBytes());
        Assert.assertEquals((long)a.getLiveWorkerNum(), (long)b.getLiveWorkerNum());
        Assert.assertEquals((long)a.getLostWorkerNum(), (long)b.getLostWorkerNum());
        Assert.assertEquals((long)a.getUsedBytes(), (long)b.getUsedBytes());
        Assert.assertEquals((Object)a.getUsedBytesOnTiers(), (Object)b.getUsedBytesOnTiers());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static BlockMasterInfo createRandom() {
        BlockMasterInfo result = new BlockMasterInfo();
        Random random = new Random();
        long capacityBytes = random.nextLong();
        HashMap<String, Long> capacityBytesOnTiers = new HashMap<String, Long>();
        capacityBytesOnTiers.put("MEM", capacityBytes);
        long freeBytes = random.nextLong();
        int liveWorkerNum = random.nextInt(10);
        int lostWorkerNum = random.nextInt(10);
        long usedBytes = random.nextLong();
        HashMap<String, Long> usedBytesOnTiers = new HashMap<String, Long>();
        usedBytesOnTiers.put("MEM", capacityBytes);
        result.setCapacityBytes(capacityBytes);
        result.setCapacityBytesOnTiers(capacityBytesOnTiers);
        result.setFreeBytes(freeBytes);
        result.setLiveWorkerNum(liveWorkerNum);
        result.setLostWorkerNum(lostWorkerNum);
        result.setUsedBytes(usedBytes);
        result.setUsedBytesOnTiers(usedBytesOnTiers);
        return result;
    }
}

