/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.util.CommonUtils;
import alluxio.wire.BlockLocation;
import alluxio.wire.WorkerNetAddress;
import alluxio.wire.WorkerNetAddressTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class BlockLocationTest {
    @Test
    public void json() throws Exception {
        BlockLocation blockLocation = BlockLocationTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        BlockLocation other = (BlockLocation)mapper.readValue(mapper.writeValueAsBytes((Object)blockLocation), BlockLocation.class);
        this.checkEquality(blockLocation, other);
    }

    @Test
    public void proto() {
        BlockLocation blockLocation = BlockLocationTest.createRandom();
        BlockLocation other = GrpcUtils.fromProto((alluxio.grpc.BlockLocation)GrpcUtils.toProto((BlockLocation)blockLocation));
        this.checkEquality(blockLocation, other);
    }

    public void checkEquality(BlockLocation a, BlockLocation b) {
        Assert.assertEquals((long)a.getWorkerId(), (long)b.getWorkerId());
        Assert.assertEquals((Object)a.getWorkerAddress(), (Object)b.getWorkerAddress());
        Assert.assertEquals((Object)a.getTierAlias(), (Object)b.getTierAlias());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static BlockLocation createRandom() {
        BlockLocation result = new BlockLocation();
        Random random = new Random();
        long workerId = random.nextLong();
        WorkerNetAddress workerAddress = WorkerNetAddressTest.createRandom();
        String tierAlias = CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        String mediumType = CommonUtils.randomAlphaNumString((int)random.nextInt(3));
        result.setWorkerId(workerId);
        result.setWorkerAddress(workerAddress);
        result.setTierAlias(tierAlias);
        result.setMediumType(mediumType);
        return result;
    }
}

