/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.grpc.GrpcUtils;
import alluxio.wire.BlockInfo;
import alluxio.wire.BlockLocation;
import alluxio.wire.BlockLocationTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class BlockInfoTest {
    @Test
    public void json() throws Exception {
        BlockInfo blockInfo = BlockInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        BlockInfo other = (BlockInfo)mapper.readValue(mapper.writeValueAsBytes((Object)blockInfo), BlockInfo.class);
        this.checkEquality(blockInfo, other);
    }

    @Test
    public void proto() {
        BlockInfo blockInfo = BlockInfoTest.createRandom();
        BlockInfo other = GrpcUtils.fromProto((alluxio.grpc.BlockInfo)GrpcUtils.toProto((BlockInfo)blockInfo));
        this.checkEquality(blockInfo, other);
    }

    public void checkEquality(BlockInfo a, BlockInfo b) {
        Assert.assertEquals((long)a.getBlockId(), (long)b.getBlockId());
        Assert.assertEquals((long)a.getLength(), (long)b.getLength());
        Assert.assertEquals((Object)a.getLocations(), (Object)b.getLocations());
        Assert.assertEquals((Object)a, (Object)b);
    }

    public static BlockInfo createRandom() {
        BlockInfo result = new BlockInfo();
        Random random = new Random();
        long blockId = random.nextLong();
        long length = random.nextLong();
        ArrayList<BlockLocation> locations = new ArrayList<BlockLocation>();
        long numLocations = random.nextInt(10);
        int i = 0;
        while ((long)i < numLocations) {
            locations.add(BlockLocationTest.createRandom());
            ++i;
        }
        result.setBlockId(blockId);
        result.setLength(length);
        result.setLocations(locations);
        return result;
    }
}

