/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.test.util.CommonUtils;
import alluxio.wire.AlluxioMasterInfo;
import alluxio.wire.AlluxioWorkerInfo;
import alluxio.wire.Capacity;
import alluxio.wire.CapacityTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class AlluxioWorkerInfoTest {
    @Test
    public void json() throws Exception {
        AlluxioWorkerInfo alluxioWorkerInfo = AlluxioWorkerInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        AlluxioWorkerInfo other = (AlluxioWorkerInfo)mapper.readValue(mapper.writeValueAsBytes((Object)alluxioWorkerInfo), AlluxioWorkerInfo.class);
        this.checkEquality(alluxioWorkerInfo, other);
    }

    @Test
    public void equals() {
        CommonUtils.testEquals(AlluxioMasterInfo.class, new String[0]);
    }

    private void checkEquality(AlluxioWorkerInfo a, AlluxioWorkerInfo b) {
        Assert.assertEquals((Object)a.getCapacity(), (Object)b.getCapacity());
        Assert.assertEquals((Object)a.getConfiguration(), (Object)b.getConfiguration());
        Assert.assertEquals((Object)a.getMetrics(), (Object)b.getMetrics());
        Assert.assertEquals((Object)a.getRpcAddress(), (Object)b.getRpcAddress());
        Assert.assertEquals((long)a.getStartTimeMs(), (long)b.getStartTimeMs());
        Assert.assertEquals((Object)a.getTierCapacity(), (Object)b.getTierCapacity());
        Assert.assertEquals((long)a.getUptimeMs(), (long)b.getUptimeMs());
        Assert.assertEquals((Object)a.getVersion(), (Object)b.getVersion());
        Assert.assertEquals((Object)a, (Object)b);
    }

    private static AlluxioWorkerInfo createRandom() {
        AlluxioWorkerInfo result = new AlluxioWorkerInfo();
        Random random = new Random();
        Capacity capacity = CapacityTest.createRandom();
        HashMap<String, String> configuration = new HashMap<String, String>();
        long numConfiguration = random.nextInt(10);
        int i = 0;
        while ((long)i < numConfiguration) {
            configuration.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
            ++i;
        }
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        long numMetrics = random.nextInt(10);
        int i2 = 0;
        while ((long)i2 < numMetrics) {
            metrics.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), random.nextLong());
            ++i2;
        }
        String rpcAddress = alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        long startTimeMs = random.nextLong();
        HashMap<String, Capacity> tierCapacity = new HashMap<String, Capacity>();
        HashMap tierPaths = new HashMap();
        long numTiers = random.nextInt(10);
        int i3 = 0;
        while ((long)i3 < numTiers) {
            tierCapacity.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), CapacityTest.createRandom());
            ArrayList<String> paths = new ArrayList<String>();
            long numPaths = random.nextInt(10);
            int j = 0;
            while ((long)j < numPaths) {
                paths.add(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
                ++j;
            }
            tierPaths.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), paths);
            ++i3;
        }
        long uptimeMs = random.nextLong();
        String version = alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        result.setCapacity(capacity);
        result.setConfiguration(configuration);
        result.setMetrics(metrics);
        result.setRpcAddress(rpcAddress);
        result.setStartTimeMs(startTimeMs);
        result.setTierCapacity(tierCapacity);
        result.setTierPaths(tierPaths);
        result.setUptimeMs(uptimeMs);
        result.setVersion(version);
        return result;
    }
}

