/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.test.util.CommonUtils;
import alluxio.wire.AlluxioProxyInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AlluxioProxyInfoTest {
    @Test
    public void json() throws Exception {
        AlluxioProxyInfo alluxioProxyInfo = AlluxioProxyInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        AlluxioProxyInfo other = (AlluxioProxyInfo)mapper.readValue(mapper.writeValueAsBytes((Object)alluxioProxyInfo), AlluxioProxyInfo.class);
        this.checkEquality(alluxioProxyInfo, other);
    }

    @Test
    public void equals() {
        CommonUtils.testEquals(AlluxioProxyInfo.class, new String[0]);
    }

    private void checkEquality(AlluxioProxyInfo a, AlluxioProxyInfo b) {
        Assert.assertEquals((Object)a.getConfiguration(), (Object)b.getConfiguration());
        Assert.assertEquals((long)a.getStartTimeMs(), (long)b.getStartTimeMs());
        Assert.assertEquals((long)a.getUptimeMs(), (long)b.getUptimeMs());
        Assert.assertEquals((Object)a.getVersion(), (Object)b.getVersion());
        Assert.assertEquals((Object)a, (Object)b);
    }

    private static AlluxioProxyInfo createRandom() {
        AlluxioProxyInfo result = new AlluxioProxyInfo();
        Random random = new Random();
        HashMap<String, String> configuration = new HashMap<String, String>();
        long numConfiguration = random.nextInt(10);
        int i = 0;
        while ((long)i < numConfiguration) {
            configuration.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
            ++i;
        }
        long startTimeMs = random.nextLong();
        long uptimeMs = random.nextLong();
        String version = alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        result.setConfiguration(configuration);
        result.setStartTimeMs(startTimeMs);
        result.setUptimeMs(uptimeMs);
        result.setVersion(version);
        return result;
    }
}

