/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.test.util.CommonUtils;
import alluxio.wire.AlluxioMasterInfo;
import alluxio.wire.Capacity;
import alluxio.wire.CapacityTest;
import alluxio.wire.WorkerInfo;
import alluxio.wire.WorkerInfoTest;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class AlluxioMasterInfoTest {
    @Test
    public void json() throws Exception {
        AlluxioMasterInfo alluxioMasterInfo = AlluxioMasterInfoTest.createRandom();
        ObjectMapper mapper = new ObjectMapper();
        AlluxioMasterInfo other = (AlluxioMasterInfo)mapper.readValue(mapper.writeValueAsBytes((Object)alluxioMasterInfo), AlluxioMasterInfo.class);
        this.checkEquality(alluxioMasterInfo, other);
    }

    @Test
    public void equals() {
        CommonUtils.testEquals(AlluxioMasterInfo.class, new String[0]);
    }

    private void checkEquality(AlluxioMasterInfo a, AlluxioMasterInfo b) {
        Assert.assertEquals((Object)a.getCapacity(), (Object)b.getCapacity());
        Assert.assertEquals((Object)a.getConfiguration(), (Object)b.getConfiguration());
        Assert.assertEquals((Object)a.getLostWorkers(), (Object)b.getLostWorkers());
        Assert.assertEquals((Object)a.getMetrics(), (Object)b.getMetrics());
        Assert.assertEquals((Object)a.getRpcAddress(), (Object)b.getRpcAddress());
        Assert.assertEquals((long)a.getStartTimeMs(), (long)b.getStartTimeMs());
        Assert.assertEquals((Object)a.getTierCapacity(), (Object)b.getTierCapacity());
        Assert.assertEquals((Object)a.getUfsCapacity(), (Object)b.getUfsCapacity());
        Assert.assertEquals((long)a.getUptimeMs(), (long)b.getUptimeMs());
        Assert.assertEquals((Object)a.getVersion(), (Object)b.getVersion());
        Assert.assertEquals((Object)a.getWorkers(), (Object)b.getWorkers());
        Assert.assertEquals((Object)a, (Object)b);
    }

    private static AlluxioMasterInfo createRandom() {
        AlluxioMasterInfo result = new AlluxioMasterInfo();
        Random random = new Random();
        Capacity capacity = CapacityTest.createRandom();
        HashMap<String, String> configuration = new HashMap<String, String>();
        long numConfiguration = random.nextInt(10);
        int i = 0;
        while ((long)i < numConfiguration) {
            configuration.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)));
            ++i;
        }
        ArrayList<WorkerInfo> lostWorkers = new ArrayList<WorkerInfo>();
        long numLostWorkers = random.nextInt(10);
        int i2 = 0;
        while ((long)i2 < numLostWorkers) {
            lostWorkers.add(WorkerInfoTest.createRandom());
            ++i2;
        }
        HashMap<String, Long> metrics = new HashMap<String, Long>();
        long numMetrics = random.nextInt(10);
        int i3 = 0;
        while ((long)i3 < numMetrics) {
            metrics.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), random.nextLong());
            ++i3;
        }
        String rpcAddress = alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        long startTimeMs = random.nextLong();
        HashMap<String, Capacity> tierCapacity = new HashMap<String, Capacity>();
        long numTiers = random.nextInt(10);
        int i4 = 0;
        while ((long)i4 < numTiers) {
            tierCapacity.put(alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10)), CapacityTest.createRandom());
            ++i4;
        }
        Capacity ufsCapacity = CapacityTest.createRandom();
        long uptimeMs = random.nextLong();
        String version = alluxio.util.CommonUtils.randomAlphaNumString((int)random.nextInt(10));
        ArrayList<WorkerInfo> workers = new ArrayList<WorkerInfo>();
        long numWorkers = random.nextInt(10);
        int i5 = 0;
        while ((long)i5 < numWorkers) {
            workers.add(WorkerInfoTest.createRandom());
            ++i5;
        }
        result.setCapacity(capacity);
        result.setConfiguration(configuration);
        result.setLostWorkers(lostWorkers);
        result.setMetrics(metrics);
        result.setRpcAddress(rpcAddress);
        result.setStartTimeMs(startTimeMs);
        result.setTierCapacity(tierCapacity);
        result.setUfsCapacity(ufsCapacity);
        result.setUptimeMs(uptimeMs);
        result.setVersion(version);
        result.setWorkers(workers);
        return result;
    }
}

