/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.CommonUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.wire.WorkerNetAddress;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class NetworkAddressUtilsTest {
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();

    @After
    public void after() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void testGetConnectAddress() throws Exception {
        for (NetworkAddressUtils.ServiceType service : NetworkAddressUtils.ServiceType.values()) {
            if (service == NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT || service == NetworkAddressUtils.ServiceType.MASTER_RAFT) continue;
            this.getConnectAddress(service);
        }
    }

    private void getConnectAddress(NetworkAddressUtils.ServiceType service) throws Exception {
        int resolveTimeout = (int)this.mConfiguration.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
        String localHostName = NetworkAddressUtils.getLocalHostName((int)resolveTimeout);
        InetSocketAddress masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved(localHostName, service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.unset(service.getHostNameKey());
        this.mConfiguration.set(service.getBindHostKey(), (Object)"bind.host");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("bind.host", service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"connect.host");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("connect.host", service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"0.0.0.0");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("bind.host", service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"0.0.0.0");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved(localHostName, service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"connect.host");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("connect.host", service.getDefaultPort()), (Object)masterAddress);
        this.mConfiguration.set(service.getPortKey(), (Object)"10000");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("connect.host", 10000), (Object)masterAddress);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"bind.host");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("connect.host", 10000), (Object)masterAddress);
        this.mConfiguration.unset(service.getHostNameKey());
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("bind.host", 10000), (Object)masterAddress);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"0.0.0.0");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved(localHostName, 10000), (Object)masterAddress);
    }

    @Test
    public void testGetBindAddress() throws Exception {
        for (NetworkAddressUtils.ServiceType service : NetworkAddressUtils.ServiceType.values()) {
            if (service == NetworkAddressUtils.ServiceType.JOB_MASTER_RAFT || service == NetworkAddressUtils.ServiceType.MASTER_RAFT) continue;
            this.getBindAddress(service);
        }
    }

    private void getBindAddress(NetworkAddressUtils.ServiceType service) throws Exception {
        InetSocketAddress address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", service.getDefaultPort()), (Object)address);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"bind.host");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("bind.host", service.getDefaultPort()), (Object)address);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"connect.host");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("bind.host", service.getDefaultPort()), (Object)address);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"0.0.0.0");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("bind.host", service.getDefaultPort()), (Object)address);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"0.0.0.0");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", service.getDefaultPort()), (Object)address);
        this.mConfiguration.set(service.getHostNameKey(), (Object)"connect.host");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", service.getDefaultPort()), (Object)address);
        switch (service) {
            case JOB_MASTER_RAFT: {
                this.mConfiguration.set(PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_PORT, (Object)"20000");
                break;
            }
            case MASTER_RAFT: {
                this.mConfiguration.set(PropertyKey.MASTER_EMBEDDED_JOURNAL_PORT, (Object)"20000");
                break;
            }
            case JOB_MASTER_RPC: {
                this.mConfiguration.set(PropertyKey.JOB_MASTER_RPC_PORT, (Object)"20000");
                break;
            }
            case JOB_MASTER_WEB: {
                this.mConfiguration.set(PropertyKey.JOB_MASTER_WEB_PORT, (Object)"20000");
                break;
            }
            case JOB_WORKER_RPC: {
                this.mConfiguration.set(PropertyKey.JOB_WORKER_RPC_PORT, (Object)"20000");
                break;
            }
            case JOB_WORKER_WEB: {
                this.mConfiguration.set(PropertyKey.JOB_WORKER_WEB_PORT, (Object)"20000");
                break;
            }
            case MASTER_RPC: {
                this.mConfiguration.set(PropertyKey.MASTER_RPC_PORT, (Object)"20000");
                break;
            }
            case MASTER_WEB: {
                this.mConfiguration.set(PropertyKey.MASTER_WEB_PORT, (Object)"20000");
                break;
            }
            case PROXY_WEB: {
                this.mConfiguration.set(PropertyKey.PROXY_WEB_PORT, (Object)"20000");
                break;
            }
            case WORKER_RPC: {
                this.mConfiguration.set(PropertyKey.WORKER_RPC_PORT, (Object)"20000");
                break;
            }
            case WORKER_WEB: {
                this.mConfiguration.set(PropertyKey.WORKER_WEB_PORT, (Object)"20000");
                break;
            }
            default: {
                Assert.fail((String)("Unrecognized service type: " + service.toString()));
            }
        }
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", 20000), (Object)address);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"bind.host");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("bind.host", 20000), (Object)address);
        this.mConfiguration.unset(service.getHostNameKey());
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("bind.host", 20000), (Object)address);
        this.mConfiguration.set(service.getBindHostKey(), (Object)"0.0.0.0");
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", 20000), (Object)address);
        this.mConfiguration.unset(service.getBindHostKey());
        address = NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)service, (AlluxioConfiguration)this.mConfiguration);
        Assert.assertEquals((Object)new InetSocketAddress("0.0.0.0", 20000), (Object)address);
    }

    @Test
    public void getLocalNodeNameClient() throws Exception {
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.CLIENT);
        try (Closeable c = new ConfigurationRule(PropertyKey.LOCALITY_TIER_NODE, "client", this.mConfiguration).toResource();){
            Assert.assertEquals((Object)"client", (Object)NetworkAddressUtils.getLocalNodeName((AlluxioConfiguration)this.mConfiguration));
        }
    }

    @Test
    public void getLocalNodeNameWorker() throws Exception {
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.WORKER);
        try (Closeable c = new ConfigurationRule(PropertyKey.WORKER_HOSTNAME, "worker", this.mConfiguration).toResource();){
            Assert.assertEquals((Object)"worker", (Object)NetworkAddressUtils.getLocalNodeName((AlluxioConfiguration)this.mConfiguration));
        }
    }

    @Test
    public void getLocalNodeNameMaster() throws Exception {
        CommonUtils.PROCESS_TYPE.set(CommonUtils.ProcessType.MASTER);
        try (Closeable c = new ConfigurationRule(PropertyKey.MASTER_HOSTNAME, "master", this.mConfiguration).toResource();){
            Assert.assertEquals((Object)"master", (Object)NetworkAddressUtils.getLocalNodeName((AlluxioConfiguration)this.mConfiguration));
        }
    }

    @Test
    public void getLocalNodeNameLookup() throws Exception {
        int resolveTimeout = (int)this.mConfiguration.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
        Assert.assertEquals((Object)NetworkAddressUtils.getLocalHostName((int)resolveTimeout), (Object)NetworkAddressUtils.getLocalNodeName((AlluxioConfiguration)this.mConfiguration));
    }

    @Test
    public void resolveHostName() throws UnknownHostException {
        Assert.assertEquals((Object)NetworkAddressUtils.resolveHostName((String)""), null);
        Assert.assertEquals((Object)NetworkAddressUtils.resolveHostName(null), null);
        Assert.assertEquals((Object)NetworkAddressUtils.resolveHostName((String)"localhost"), (Object)"localhost");
    }

    @Test
    public void resolveIpAddress() throws UnknownHostException {
        Assert.assertEquals((Object)NetworkAddressUtils.resolveIpAddress((String)"localhost"), (Object)"127.0.0.1");
        Assert.assertEquals((Object)NetworkAddressUtils.resolveIpAddress((String)"127.0.0.1"), (Object)"127.0.0.1");
    }

    @Test(expected=NullPointerException.class)
    public void resolveNullIpAddress() throws UnknownHostException {
        NetworkAddressUtils.resolveIpAddress(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveEmptyIpAddress() throws UnknownHostException {
        NetworkAddressUtils.resolveIpAddress((String)"");
    }

    @Test
    public void getFqdnHost() throws UnknownHostException {
        Assert.assertEquals((Object)NetworkAddressUtils.getFqdnHost((InetSocketAddress)new InetSocketAddress("localhost", 0)), (Object)"localhost");
        Assert.assertEquals((Object)NetworkAddressUtils.getFqdnHost((WorkerNetAddress)new WorkerNetAddress().setHost("localhost")), (Object)"localhost");
    }

    @Test
    public void getConfiguredClientHostname() {
        this.mConfiguration.set(PropertyKey.LOCALITY_TIER_NODE, (Object)"clienthost");
        Assert.assertEquals((Object)"clienthost", (Object)NetworkAddressUtils.getClientHostName((AlluxioConfiguration)this.mConfiguration));
    }

    @Test
    public void getDefaultClientHostname() {
        int resolveTimeout = (int)this.mConfiguration.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
        Assert.assertEquals((Object)NetworkAddressUtils.getLocalHostName((int)resolveTimeout), (Object)NetworkAddressUtils.getClientHostName((AlluxioConfiguration)this.mConfiguration));
    }
}

