/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.network;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.network.NetworkAddressUtils;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class GetMasterWorkerAddressTest {
    @Test
    public void getMasterAddress() {
        InstancedConfiguration conf = ConfigurationTestUtils.defaults();
        conf.set(PropertyKey.MASTER_HOSTNAME, (Object)"RemoteMaster1");
        conf.set(PropertyKey.MASTER_RPC_PORT, (Object)"10000");
        int resolveTimeout = (int)conf.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS);
        String defaultHostname = NetworkAddressUtils.getLocalHostName((int)resolveTimeout);
        int defaultPort = Integer.parseInt(PropertyKey.MASTER_RPC_PORT.getDefaultValue());
        InetSocketAddress masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)conf);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("RemoteMaster1", 10000), (Object)masterAddress);
        conf = ConfigurationTestUtils.defaults();
        conf.set(PropertyKey.MASTER_RPC_PORT, (Object)"20000");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)conf);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved(defaultHostname, 20000), (Object)masterAddress);
        conf = ConfigurationTestUtils.defaults();
        conf.set(PropertyKey.MASTER_HOSTNAME, (Object)"RemoteMaster3");
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)conf);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved("RemoteMaster3", defaultPort), (Object)masterAddress);
        conf = ConfigurationTestUtils.defaults();
        masterAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (AlluxioConfiguration)conf);
        Assert.assertEquals((Object)InetSocketAddress.createUnresolved(defaultHostname, defaultPort), (Object)masterAddress);
    }
}

