/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.logging;

import alluxio.util.CommonUtils;
import alluxio.util.logging.SamplingLogger;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

public class SamplingLoggerTest {
    private Logger mBaseLogger;
    private SamplingLogger mSamplingLogger;

    @Test
    public void sampleSingle() {
        this.setupLogger(10000L);
        ((Logger)Mockito.doReturn((Object)true).when((Object)this.mBaseLogger)).isWarnEnabled();
        for (int i = 0; i < 10; ++i) {
            this.mSamplingLogger.warn("warning");
        }
        ((Logger)Mockito.verify((Object)this.mBaseLogger, (VerificationMode)Mockito.times((int)1))).warn("warning");
    }

    @Test
    public void sampleMultiple() {
        this.setupLogger(10000L);
        ((Logger)Mockito.doReturn((Object)true).when((Object)this.mBaseLogger)).isWarnEnabled();
        for (int i = 0; i < 10; ++i) {
            this.mSamplingLogger.warn("warning1");
            this.mSamplingLogger.warn("warning2");
        }
        ((Logger)Mockito.verify((Object)this.mBaseLogger, (VerificationMode)Mockito.times((int)1))).warn("warning1");
        ((Logger)Mockito.verify((Object)this.mBaseLogger, (VerificationMode)Mockito.times((int)1))).warn("warning2");
    }

    @Test
    public void sampleAfterCooldown() {
        this.setupLogger(1L);
        ((Logger)Mockito.doReturn((Object)true).when((Object)this.mBaseLogger)).isWarnEnabled();
        for (int i = 0; i < 10; ++i) {
            this.mSamplingLogger.warn("warning1");
            this.mSamplingLogger.warn("warning2");
            CommonUtils.sleepMs((long)2L);
        }
        ((Logger)Mockito.verify((Object)this.mBaseLogger, (VerificationMode)Mockito.times((int)10))).warn("warning1");
        ((Logger)Mockito.verify((Object)this.mBaseLogger, (VerificationMode)Mockito.times((int)10))).warn("warning2");
    }

    private void setupLogger(long cooldown) {
        this.mBaseLogger = (Logger)Mockito.mock(Logger.class);
        this.mSamplingLogger = new SamplingLogger(this.mBaseLogger, cooldown);
    }
}

