/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.AlluxioURI;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidPathException;
import alluxio.util.io.PathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class PathUtilsTest {
    @Rule
    public final ExpectedException mException = ExpectedException.none();

    @Test
    public void cleanPathNoException() throws InvalidPathException {
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo/bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo/bar/"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo//bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo//bar//"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo///////bar//////"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo/./bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.cleanPath((String)"/foo/././bar"));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.cleanPath((String)"/foo/bar/.."));
        Assert.assertEquals((Object)"/bar", (Object)PathUtils.cleanPath((String)"/foo/../bar"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.cleanPath((String)"/foo/bar/../.."));
        Assert.assertNull((Object)PathUtils.cleanPath((String)"/foo/bar/../../.."));
    }

    @Test
    public void cleanPathException() throws InvalidPathException {
        this.mException.expect(InvalidPathException.class);
        PathUtils.cleanPath((String)"");
    }

    @Test
    public void concatPath() {
        Assert.assertEquals((Object)"/", (Object)PathUtils.concatPath((Object)"/", (Object[])new Object[0]));
        Assert.assertEquals((Object)"/", (Object)PathUtils.concatPath((Object)"/", (Object)""));
        Assert.assertEquals((Object)"/bar", (Object)PathUtils.concatPath((Object)"/", (Object)"bar"));
        Assert.assertEquals((Object)"foo", (Object)PathUtils.concatPath((Object)"foo", (Object[])new Object[0]));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.concatPath((Object)"/foo", (Object[])new Object[0]));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.concatPath((Object)"/foo", (Object)""));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo", (Object)"bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo", (Object)"bar/"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo", (Object)"/bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo", (Object)"/bar/"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo/", (Object)"bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo/", (Object)"bar/"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo/", (Object)"/bar"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo/", (Object)"/bar/"));
        Assert.assertEquals((Object)"/foo/bar", (Object)PathUtils.concatPath((Object)"/foo/", (Object)"bar//"));
        Assert.assertEquals((Object)"/foo/bar/a/b/c", (Object)PathUtils.concatPath((Object)"/foo", (Object[])new Object[]{"bar", "a", "b", "c"}));
        Assert.assertEquals((Object)"/foo/bar/b/c", (Object)PathUtils.concatPath((Object)"/foo", (Object[])new Object[]{"bar", "", "b", "c"}));
        Assert.assertEquals((Object)"/foo/bar/1", (Object)PathUtils.concatPath((Object)"/foo", (Object[])new Object[]{"bar", 1}));
        Assert.assertEquals((Object)"/foo/bar/2", (Object)PathUtils.concatPath((Object)"/foo", (Object[])new Object[]{"bar", 2L}));
        Assert.assertEquals((Object)"alluxio://host:port/foo/bar", (Object)PathUtils.concatPath((Object)"alluxio://host:port", (Object[])new Object[]{"/foo", "bar"}));
    }

    @Test
    public void findLowestCommonAncestor() {
        Assert.assertNull((Object)PathUtils.findLowestCommonAncestor(null));
        Assert.assertNull((Object)PathUtils.findLowestCommonAncestor((Collection)Collections.EMPTY_LIST));
        ArrayList<AlluxioURI> paths = new ArrayList<AlluxioURI>();
        paths.add(new AlluxioURI("/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.clear();
        paths.add(new AlluxioURI("/a"));
        Assert.assertEquals((Object)"/a", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.add(new AlluxioURI("/a/b"));
        Assert.assertEquals((Object)"/a", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.clear();
        paths.add(new AlluxioURI("/a/c"));
        paths.add(new AlluxioURI("/a/d/"));
        Assert.assertEquals((Object)"/a", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.add(new AlluxioURI("/b/a/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.clear();
        paths.add(new AlluxioURI("/a/b/c"));
        paths.add(new AlluxioURI("/a/b/d"));
        paths.add(new AlluxioURI("/a/b/e"));
        Assert.assertEquals((Object)"/a/b", (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
        paths.clear();
        String prefix = "/a/b/c";
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    paths.add(new AlluxioURI(String.format("%s/%d/%d/%d", prefix, i, j, k)));
                }
            }
        }
        Assert.assertEquals((Object)prefix, (Object)PathUtils.findLowestCommonAncestor(paths).getPath());
    }

    @Test
    public void getParent() throws InvalidPathException {
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.getParent((String)"/foo/bar"));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.getParent((String)"/foo/bar/"));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.getParent((String)"/foo/./bar/"));
        Assert.assertEquals((Object)"/foo", (Object)PathUtils.getParent((String)"/foo/././bar/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/foo"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/foo/bar/../"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/foo/../bar/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/foo/bar/../../"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getParent((String)"/foo/../bar/../"));
    }

    @Test
    public void getPathComponentsNoException() throws InvalidPathException {
        Assert.assertArrayEquals((Object[])new String[]{""}, (Object[])PathUtils.getPathComponents((String)"/"));
        Assert.assertArrayEquals((Object[])new String[]{"", "bar"}, (Object[])PathUtils.getPathComponents((String)"/bar"));
        Assert.assertArrayEquals((Object[])new String[]{"", "foo", "bar"}, (Object[])PathUtils.getPathComponents((String)"/foo/bar"));
        Assert.assertArrayEquals((Object[])new String[]{"", "foo", "bar"}, (Object[])PathUtils.getPathComponents((String)"/foo/bar/"));
        Assert.assertArrayEquals((Object[])new String[]{"", "bar"}, (Object[])PathUtils.getPathComponents((String)"/foo/../bar"));
        Assert.assertArrayEquals((Object[])new String[]{"", "foo", "bar", "a", "b", "c"}, (Object[])PathUtils.getPathComponents((String)"/foo//bar/a/b/c"));
    }

    @Test
    public void getPathComponentsException() throws InvalidPathException {
        this.mException.expect(InvalidPathException.class);
        PathUtils.getPathComponents((String)"");
    }

    @Test
    public void subtractPaths() throws InvalidPathException {
        Assert.assertEquals((Object)"b/c", (Object)PathUtils.subtractPaths((String)"/a/b/c", (String)"/a"));
        Assert.assertEquals((Object)"b/c", (Object)PathUtils.subtractPaths((String)"/a/b/c", (String)"/a/"));
        Assert.assertEquals((Object)"b/c", (Object)PathUtils.subtractPaths((String)"/a/b/c", (String)"/a/"));
        Assert.assertEquals((Object)"c", (Object)PathUtils.subtractPaths((String)"/a/b/c", (String)"/a/b"));
        Assert.assertEquals((Object)"a/b/c", (Object)PathUtils.subtractPaths((String)"/a/b/c", (String)"/"));
        Assert.assertEquals((Object)"", (Object)PathUtils.subtractPaths((String)"/", (String)"/"));
        Assert.assertEquals((Object)"", (Object)PathUtils.subtractPaths((String)"/a/b/", (String)"/a/b"));
        Assert.assertEquals((Object)"", (Object)PathUtils.subtractPaths((String)"/a/b", (String)"/a/b"));
    }

    @Test
    public void subtractPathsException() throws InvalidPathException {
        try {
            PathUtils.subtractPaths((String)"", (String)"/");
            Assert.fail((String)"\"\" should throw an InvalidPathException");
        }
        catch (InvalidPathException e) {
            Assert.assertEquals((Object)ExceptionMessage.PATH_INVALID.getMessage(new Object[]{""}), (Object)e.getMessage());
        }
        try {
            PathUtils.subtractPaths((String)"/", (String)"noslash");
            Assert.fail((String)"noslash should be an invalid path");
        }
        catch (InvalidPathException e) {
            Assert.assertEquals((Object)ExceptionMessage.PATH_INVALID.getMessage(new Object[]{"noslash"}), (Object)e.getMessage());
        }
        try {
            PathUtils.subtractPaths((String)"/a", (String)"/not/a/prefix");
            Assert.fail((String)"subtractPaths should complain about the prefix not being a prefix");
        }
        catch (RuntimeException e) {
            String expectedMessage = "Cannot subtract /not/a/prefix from /a because it is not a prefix";
            Assert.assertEquals((Object)expectedMessage, (Object)e.getMessage());
        }
    }

    @Test
    public void hasPrefix() throws InvalidPathException {
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/", (String)"/"));
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/a", (String)"/a"));
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/a", (String)"/a/"));
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/a"));
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/a/b"));
        Assert.assertTrue((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/a/b/c"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/", (String)"/a"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/", (String)"/a/b/c"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a", (String)"/a/b/c"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/b", (String)"/a/b/c"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/aa"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/a/bb"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/b/c", (String)"/a/b/cc"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/aa/b/c", (String)"/a"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/bb/c", (String)"/a/b"));
        Assert.assertFalse((boolean)PathUtils.hasPrefix((String)"/a/b/cc", (String)"/a/b/c"));
    }

    @Test
    public void isRoot() throws InvalidPathException {
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/bar"));
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/bar/"));
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/./bar/"));
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/././bar/"));
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/../bar"));
        Assert.assertFalse((boolean)PathUtils.isRoot((String)"/foo/../bar/"));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/"));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/"));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/."));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/./"));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/foo/.."));
        Assert.assertTrue((boolean)PathUtils.isRoot((String)"/foo/../"));
    }

    @Test
    public void temporaryFileName() {
        Assert.assertEquals((Object)PathUtils.temporaryFileName((long)1L, (String)"/"), (Object)PathUtils.temporaryFileName((long)1L, (String)"/"));
        Assert.assertNotEquals((Object)PathUtils.temporaryFileName((long)1L, (String)"/"), (Object)PathUtils.temporaryFileName((long)2L, (String)"/"));
        Assert.assertNotEquals((Object)PathUtils.temporaryFileName((long)1L, (String)"/"), (Object)PathUtils.temporaryFileName((long)1L, (String)"/a"));
    }

    @Test
    public void getPermanentFileName() {
        Assert.assertEquals((Object)"/", (Object)PathUtils.getPermanentFileName((String)PathUtils.temporaryFileName((long)1L, (String)"/")));
        Assert.assertEquals((Object)"/", (Object)PathUtils.getPermanentFileName((String)PathUtils.temporaryFileName((long)-1L, (String)"/")));
        Assert.assertEquals((Object)"/foo.alluxio.0x0123456789ABCDEF.tmp", (Object)PathUtils.getPermanentFileName((String)PathUtils.temporaryFileName((long)14324L, (String)"/foo.alluxio.0x0123456789ABCDEF.tmp")));
    }

    @Test
    public void isTemporaryFileName() {
        Assert.assertTrue((boolean)PathUtils.isTemporaryFileName((String)PathUtils.temporaryFileName((long)0L, (String)"/")));
        Assert.assertTrue((boolean)PathUtils.isTemporaryFileName((String)PathUtils.temporaryFileName((long)-1L, (String)"/")));
        Assert.assertTrue((boolean)PathUtils.isTemporaryFileName((String)"foo.alluxio.0x0123456789ABCDEF.tmp"));
        Assert.assertFalse((boolean)PathUtils.isTemporaryFileName((String)"foo.alluxio.0x      0123456789.tmp"));
        Assert.assertFalse((boolean)PathUtils.isTemporaryFileName((String)"foo.alluxio.0x0123456789ABCDEFG.tmp"));
        Assert.assertFalse((boolean)PathUtils.isTemporaryFileName((String)"foo.alluxio.0x0123456789ABCDE.tmp"));
        Assert.assertFalse((boolean)PathUtils.isTemporaryFileName((String)"foo.0x0123456789ABCDEFG.tmp"));
        Assert.assertFalse((boolean)PathUtils.isTemporaryFileName((String)"alluxio.0x0123456789ABCDEFG"));
    }

    @Test
    public void uniqPath() {
        Assert.assertNotEquals((Object)PathUtils.uniqPath(), (Object)PathUtils.uniqPath());
    }

    @Test
    public void validatePath() throws InvalidPathException {
        PathUtils.validatePath((String)"/foo/bar");
        PathUtils.validatePath((String)"/foo/bar/");
        PathUtils.validatePath((String)"/foo/./bar/");
        PathUtils.validatePath((String)"/foo/././bar/");
        PathUtils.validatePath((String)"/foo/../bar");
        PathUtils.validatePath((String)"/foo/../bar/");
        ArrayList<String> invalidPaths = new ArrayList<String>();
        invalidPaths.add(null);
        invalidPaths.add("");
        for (String invalidPath : invalidPaths) {
            try {
                PathUtils.validatePath((String)invalidPath);
                Assert.fail((String)("validatePath(" + invalidPath + ") did not fail"));
            }
            catch (InvalidPathException invalidPathException) {}
        }
    }

    @Test
    public void normalizePath() throws Exception {
        Assert.assertEquals((Object)"/", (Object)PathUtils.normalizePath((String)"", (String)"/"));
        Assert.assertEquals((Object)"/", (Object)PathUtils.normalizePath((String)"/", (String)"/"));
        Assert.assertEquals((Object)"/foo/bar/", (Object)PathUtils.normalizePath((String)"/foo/bar", (String)"/"));
        Assert.assertEquals((Object)"/foo/bar/", (Object)PathUtils.normalizePath((String)"/foo/bar/", (String)"/"));
        Assert.assertEquals((Object)"/foo/bar//", (Object)PathUtils.normalizePath((String)"/foo/bar//", (String)"/"));
        Assert.assertEquals((Object)"/foo/bar%", (Object)PathUtils.normalizePath((String)"/foo/bar", (String)"%"));
    }
}

