/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.util.io.ByteIOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class ByteIOUtilsTest {
    private byte[] mBuf = new byte[1024];

    @Test
    public void readWriteByte() {
        long[] values;
        for (long i : values = new long[]{0L, 1L, 2L, 127L, 255L}) {
            byte v = (byte)i;
            ByteIOUtils.writeByte((byte[])this.mBuf, (int)0, (byte)v);
            Assert.assertEquals((long)v, (long)ByteIOUtils.readByte((byte[])this.mBuf, (int)0));
        }
    }

    @Test
    public void readWriteShort() {
        long[] values;
        for (long i : values = new long[]{0L, 1L, 2L, 127L, 255L, 65535L}) {
            short v = (short)i;
            ByteIOUtils.writeShort((byte[])this.mBuf, (int)0, (short)v);
            Assert.assertEquals((long)v, (long)ByteIOUtils.readShort((byte[])this.mBuf, (int)0));
            ByteIOUtils.writeShort((byte[])this.mBuf, (int)1, (short)v);
            Assert.assertEquals((long)v, (long)ByteIOUtils.readShort((byte[])this.mBuf, (int)1));
        }
    }

    @Test
    public void readWriteInt() {
        long[] values;
        for (long i : values = new long[]{0L, 1L, 2L, 127L, 255L, 65535L, 0xFFFFFFL, -1L}) {
            int v = (int)i;
            for (int pos = 0; pos < 4; ++pos) {
                ByteIOUtils.writeInt((byte[])this.mBuf, (int)pos, (int)v);
                Assert.assertEquals((long)v, (long)ByteIOUtils.readInt((byte[])this.mBuf, (int)pos));
            }
        }
    }

    @Test
    public void readWriteLong() {
        long[] values;
        for (long v : values = new long[]{0L, 1L, 2L, 127L, 255L, 65535L, 0xFFFFFFL, -1L, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L}) {
            for (int pos = 0; pos < 8; ++pos) {
                ByteIOUtils.writeLong((byte[])this.mBuf, (int)0, (long)v);
                Assert.assertEquals((long)v, (long)ByteIOUtils.readLong((byte[])this.mBuf, (int)0));
            }
        }
    }
}

