/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public final class BufferUtilsTest {
    @Test
    public void cloneByteBuffer() {
        int bufferSize = 10;
        ByteBuffer buf = ByteBuffer.allocate(10);
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            buf.put(i);
        }
        ByteBuffer bufClone = BufferUtils.cloneByteBuffer((ByteBuffer)buf);
        Assert.assertEquals((Object)buf, (Object)bufClone);
    }

    @Test
    public void cloneByteBufferList() {
        int bufferSize = 10;
        int listLength = 10;
        ArrayList<ByteBuffer> bufList = new ArrayList<ByteBuffer>(10);
        for (int k = 0; k < 10; ++k) {
            ByteBuffer buf = ByteBuffer.allocate(10);
            for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
                buf.put((byte)(i + k));
            }
            bufList.add(buf);
        }
        List bufListClone = BufferUtils.cloneByteBufferList(bufList);
        Assert.assertEquals((long)10L, (long)bufListClone.size());
        for (int k = 0; k < 10; ++k) {
            Assert.assertEquals(bufList.get(k), bufListClone.get(k));
        }
    }

    @Test
    public void cloneDirectByteBuffer() {
        int bufferSize = 10;
        ByteBuffer bufDirect = ByteBuffer.allocateDirect(10);
        for (byte i = 0; i < 10; i = (byte)(i + 1)) {
            bufDirect.put(i);
        }
        ByteBuffer bufClone = BufferUtils.cloneByteBuffer((ByteBuffer)bufDirect);
        Assert.assertEquals((Object)bufDirect, (Object)bufClone);
    }

    @Test
    public void cloneDirectByteBufferList() {
        int bufferSize = 10;
        int listLength = 10;
        ArrayList<ByteBuffer> bufDirectList = new ArrayList<ByteBuffer>(10);
        for (int k = 0; k < 10; ++k) {
            ByteBuffer bufDirect = ByteBuffer.allocateDirect(10);
            for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
                bufDirect.put((byte)(i + k));
            }
            bufDirectList.add(bufDirect);
        }
        List bufListClone = BufferUtils.cloneByteBufferList(bufDirectList);
        Assert.assertEquals((long)10L, (long)bufListClone.size());
        for (int k = 0; k < 10; ++k) {
            Assert.assertEquals(bufDirectList.get(k), bufListClone.get(k));
        }
    }

    @Test
    public void putIntByteBuffer() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            byte mExpected;
            int mInput;

            public TestCase(byte expected, int input) {
                this.mExpected = expected;
                this.mInput = input;
            }
        }
        testCases.add(new TestCase(0, 0));
        testCases.add(new TestCase(18, 18));
        testCases.add(new TestCase(52, 4660));
        testCases.add(new TestCase(86, 1193046));
        testCases.add(new TestCase(120, 305419896));
        for (TestCase testCase : testCases) {
            ByteBuffer buf = ByteBuffer.allocate(1);
            BufferUtils.putIntByteBuffer((ByteBuffer)buf, (int)testCase.mInput);
            Assert.assertEquals((long)testCase.mExpected, (long)buf.get(0));
        }
    }

    @Test
    public void getIncreasingByteArray() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            byte[] mExpected;
            int mLength;
            int mStart;

            public TestCase(byte[] expected, int length, int start) {
                this.mExpected = expected;
                this.mLength = length;
                this.mStart = start;
            }
        }
        testCases.add(new TestCase(new byte[0], 0, 0));
        testCases.add(new TestCase(new byte[0], 0, 3));
        testCases.add(new TestCase(new byte[]{0}, 1, 0));
        testCases.add(new TestCase(new byte[]{0, 1, 2}, 3, 0));
        testCases.add(new TestCase(new byte[]{3}, 1, 3));
        testCases.add(new TestCase(new byte[]{3, 4, 5}, 3, 3));
        for (TestCase testCase : testCases) {
            byte[] result = BufferUtils.getIncreasingByteArray((int)testCase.mStart, (int)testCase.mLength);
            Assert.assertEquals((long)testCase.mExpected.length, (long)result.length);
            for (int k = 0; k < result.length; ++k) {
                Assert.assertEquals((long)testCase.mExpected[k], (long)result[k]);
            }
        }
    }

    @Test
    public void equalIncreasingByteArray() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            boolean mExpected;
            byte[] mArray;
            int mLength;
            int mStart;

            public TestCase(boolean expected, byte[] array, int length, int start) {
                this.mExpected = expected;
                this.mArray = array;
                this.mLength = length;
                this.mStart = start;
            }
        }
        testCases.add(new TestCase(false, null, 0, 0));
        testCases.add(new TestCase(true, new byte[0], 0, 0));
        testCases.add(new TestCase(false, new byte[]{1}, 0, 0));
        testCases.add(new TestCase(true, new byte[0], 0, 3));
        testCases.add(new TestCase(false, new byte[]{1}, 0, 3));
        testCases.add(new TestCase(true, new byte[]{0}, 1, 0));
        testCases.add(new TestCase(false, new byte[]{1}, 1, 0));
        testCases.add(new TestCase(true, new byte[]{0, 1, 2}, 3, 0));
        testCases.add(new TestCase(false, new byte[]{0, 1, 2, -1}, 3, 0));
        testCases.add(new TestCase(false, new byte[]{1, 2, 3}, 3, 0));
        testCases.add(new TestCase(true, new byte[]{3}, 1, 3));
        testCases.add(new TestCase(false, new byte[]{2}, 1, 3));
        testCases.add(new TestCase(true, new byte[]{3, 4, 5}, 3, 3));
        testCases.add(new TestCase(false, new byte[]{3, 4, 5, -1}, 3, 3));
        testCases.add(new TestCase(false, new byte[]{2, 3, 4}, 3, 3));
        for (TestCase testCase : testCases) {
            boolean result = BufferUtils.equalIncreasingByteArray((int)testCase.mStart, (int)testCase.mLength, (byte[])testCase.mArray);
            Assert.assertEquals((Object)testCase.mExpected, (Object)result);
        }
    }

    @Test
    public void getIncreasingByteBuffer() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            ByteBuffer mExpected;
            int mLength;
            int mStart;

            public TestCase(ByteBuffer expected, int length, int start) {
                this.mExpected = expected;
                this.mLength = length;
                this.mStart = start;
            }
        }
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[0]), 0, 0));
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[0]), 0, 3));
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[]{0}), 1, 0));
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[]{0, 1, 2}), 3, 0));
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[]{3}), 1, 3));
        testCases.add(new TestCase(ByteBuffer.wrap(new byte[]{3, 4, 5}), 3, 3));
        for (TestCase testCase : testCases) {
            ByteBuffer result = BufferUtils.getIncreasingByteBuffer((int)testCase.mStart, (int)testCase.mLength);
            Assert.assertEquals((long)testCase.mExpected.capacity(), (long)result.capacity());
            for (int k = 0; k < result.capacity(); ++k) {
                Assert.assertEquals((long)testCase.mExpected.get(k), (long)result.get(k));
            }
        }
    }

    @Test
    public void equalIncreasingByteBuffer() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            boolean mExpected;
            ByteBuffer mBuffer;
            int mLength;
            int mStart;

            public TestCase(boolean expected, ByteBuffer buffer, int length, int start) {
                this.mExpected = expected;
                this.mBuffer = buffer;
                this.mLength = length;
                this.mStart = start;
            }
        }
        testCases.add(new TestCase(false, null, 0, 0));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[0]), 0, 0));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{1}), 0, 0));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[0]), 0, 3));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{1}), 0, 3));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[]{0}), 1, 0));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{1}), 1, 0));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[]{0, 1, 2}), 3, 0));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{0, 1, 2, -1}), 3, 0));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{1, 2, 3}), 3, 0));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[]{3}), 1, 3));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{2}), 1, 3));
        testCases.add(new TestCase(true, ByteBuffer.wrap(new byte[]{3, 4, 5}), 3, 3));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{3, 4, 5, -1}), 3, 3));
        testCases.add(new TestCase(false, ByteBuffer.wrap(new byte[]{2, 3, 4}), 3, 3));
        for (TestCase testCase : testCases) {
            boolean result = BufferUtils.equalIncreasingByteBuffer((int)testCase.mStart, (int)testCase.mLength, (ByteBuffer)testCase.mBuffer);
            Assert.assertEquals((Object)testCase.mExpected, (Object)result);
        }
    }

    @Test
    public void cleanDirectBuffer() {
        int MAX_ITERATIONS = 1024;
        int BUFFER_SIZE = 0x1000000;
        ByteBuffer[] bufferArray = new ByteBuffer[1024];
        try {
            for (int i = 0; i < 1024; ++i) {
                ByteBuffer buf;
                bufferArray[i] = buf = ByteBuffer.allocateDirect(0x1000000);
                BufferUtils.cleanDirectBuffer((ByteBuffer)buf);
            }
        }
        catch (OutOfMemoryError ooe) {
            Assert.fail((String)("cleanDirectBuffer is causing memory leak." + ooe.getMessage()));
        }
    }

    @Test
    public void sliceByteBuffer() {
        int size = 100;
        ByteBuffer buf = BufferUtils.getIncreasingByteBuffer((int)100);
        for (int slicePosition : new int[]{0, 1, 50, 99}) {
            ByteBuffer slicedBuffer = BufferUtils.sliceByteBuffer((ByteBuffer)buf, (int)slicePosition, (int)1);
            Assert.assertEquals((long)0L, (long)slicedBuffer.position());
            Assert.assertEquals((long)1L, (long)slicedBuffer.limit());
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)slicePosition, (int)1, (ByteBuffer)slicedBuffer));
            int slicedBufferLength = 100 - slicePosition;
            ByteBuffer slicedBuffer1 = BufferUtils.sliceByteBuffer((ByteBuffer)buf, (int)slicePosition, (int)slicedBufferLength);
            ByteBuffer slicedBuffer2 = BufferUtils.sliceByteBuffer((ByteBuffer)buf, (int)slicePosition);
            Assert.assertEquals((long)0L, (long)slicedBuffer1.position());
            Assert.assertEquals((long)0L, (long)slicedBuffer2.position());
            Assert.assertEquals((long)slicedBufferLength, (long)slicedBuffer1.limit());
            Assert.assertEquals((long)slicedBufferLength, (long)slicedBuffer2.limit());
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)slicePosition, (int)slicedBufferLength, (ByteBuffer)slicedBuffer1));
            Assert.assertTrue((boolean)BufferUtils.equalIncreasingByteBuffer((int)slicePosition, (int)slicedBufferLength, (ByteBuffer)slicedBuffer2));
        }
    }
}

