/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.executor;

import alluxio.util.executor.ControllableScheduler;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class ControllableSchedulerTest {
    @Test
    public void submit() throws Exception {
        CountTask task = new CountTask();
        ControllableScheduler scheduler = new ControllableScheduler();
        scheduler.submit((Runnable)task);
        Assert.assertFalse((boolean)scheduler.schedulerIsIdle());
        scheduler.runNextPendingCommand();
        Assert.assertEquals((long)1L, (long)task.runTimes());
        Assert.assertTrue((boolean)scheduler.schedulerIsIdle());
    }

    @Test
    public void schedule() throws Exception {
        CountTask task = new CountTask();
        ControllableScheduler scheduler = new ControllableScheduler();
        scheduler.schedule((Runnable)task, 5L, TimeUnit.HOURS);
        Assert.assertTrue((boolean)scheduler.schedulerIsIdle());
        scheduler.jumpAndExecute(5L, TimeUnit.HOURS);
        Assert.assertEquals((long)1L, (long)task.runTimes());
    }

    @Test
    public void scheduleAtFixedRate() throws Exception {
        CountTask task = new CountTask();
        ControllableScheduler scheduler = new ControllableScheduler();
        int delayDays = 5;
        int periodDays = 10;
        scheduler.scheduleAtFixedRate((Runnable)task, (long)delayDays, (long)periodDays, TimeUnit.DAYS);
        scheduler.jumpAndExecute(72L, TimeUnit.HOURS);
        Assert.assertEquals((long)0L, (long)task.runTimes());
        scheduler.jumpAndExecute(2880L, TimeUnit.MINUTES);
        Assert.assertEquals((long)1L, (long)task.runTimes());
        Random random = new Random();
        int daysToJump = random.nextInt(1000000000);
        scheduler.jumpAndExecute((long)daysToJump, TimeUnit.DAYS);
        Assert.assertEquals((long)(daysToJump / periodDays + 1), (long)task.runTimes());
        Assert.assertTrue((boolean)scheduler.schedulerIsIdle());
    }

    @Test
    public void cancel() {
        CountTask task = new CountTask();
        ControllableScheduler scheduler = new ControllableScheduler();
        ScheduledFuture future = scheduler.schedule((Runnable)task, 5L, TimeUnit.HOURS);
        Assert.assertTrue((boolean)scheduler.schedulerIsIdle());
        future.cancel(true);
        scheduler.jumpAndExecute(5L, TimeUnit.HOURS);
        Assert.assertEquals((long)0L, (long)task.runTimes());
    }

    private class CountTask
    implements Runnable {
        private int mNum = 0;

        CountTask() {
        }

        @Override
        public void run() {
            ++this.mNum;
        }

        public int runTimes() {
            return this.mNum;
        }
    }
}

