/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.util.OSUtils;
import alluxio.util.ShellUtils;
import alluxio.util.UnixMountInfo;
import com.google.common.base.Optional;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class ShellUtilsTest {
    @Rule
    public ExpectedException mExceptionRule = ExpectedException.none();

    @Test
    public void execCommand() throws Exception {
        String testString = "alluxio";
        String result = ShellUtils.execCommand((String[])new String[]{"bash", "-c", "echo " + testString});
        Assert.assertEquals((Object)(testString + "\n"), (Object)result);
    }

    @Test
    public void execCommandFail() throws Exception {
        String testString = "false";
        this.mExceptionRule.expect(ShellUtils.ExitCodeException.class);
        String result = ShellUtils.execCommand((String[])new String[]{"bash", "-c", " " + testString});
        Assert.assertEquals((Object)(testString + "\n"), (Object)result);
    }

    @Test
    public void execGetGroupCommand() throws Exception {
        String result = ShellUtils.execCommand((String[])ShellUtils.getGroupsForUserCommand((String)"root"));
        Assert.assertTrue((result.contains("root") || result.contains("admin") ? 1 : 0) != 0);
    }

    @Test
    public void parseRamfsMountInfoWithType() throws Exception {
        UnixMountInfo info = ShellUtils.parseMountInfo((String)"ramfs on /mnt/ramdisk type ramfs (rw,relatime,size=1gb)");
        Assert.assertEquals((Object)Optional.of((Object)"ramfs"), (Object)info.getDeviceSpec());
        Assert.assertEquals((Object)Optional.of((Object)"/mnt/ramdisk"), (Object)info.getMountPoint());
        Assert.assertEquals((Object)Optional.of((Object)"ramfs"), (Object)info.getFsType());
        Assert.assertEquals((Object)Optional.of((Object)0x40000000L), (Object)info.getOptions().getSize());
    }

    @Test
    public void parseMountInfoWithoutType() throws Exception {
        UnixMountInfo info = ShellUtils.parseMountInfo((String)"devfs on /dev (devfs, local, nobrowse)");
        Assert.assertEquals((Object)Optional.of((Object)"devfs"), (Object)info.getDeviceSpec());
        Assert.assertEquals((Object)Optional.of((Object)"/dev"), (Object)info.getMountPoint());
        Assert.assertFalse((boolean)info.getFsType().isPresent());
        Assert.assertFalse((boolean)info.getOptions().getSize().isPresent());
    }

    @Test
    public void parseTmpfsMountInfo() throws Exception {
        UnixMountInfo info = ShellUtils.parseMountInfo((String)"shm on /dev/shm type tmpfs (rw,nosuid,nodev,noexec,relatime,size=65536k)");
        Assert.assertEquals((Object)Optional.of((Object)"shm"), (Object)info.getDeviceSpec());
        Assert.assertEquals((Object)Optional.of((Object)"/dev/shm"), (Object)info.getMountPoint());
        Assert.assertEquals((Object)Optional.of((Object)"tmpfs"), (Object)info.getFsType());
        Assert.assertEquals((Object)Optional.of((Object)0x4000000L), (Object)info.getOptions().getSize());
    }

    @Test
    public void parseMountInfoSpaceInPath() throws Exception {
        UnixMountInfo info = ShellUtils.parseMountInfo((String)"/dev/disk4s1 on /Volumes/Space Path (hfs, local, nodev, nosuid, read-only, noowners, quarantine)");
        Assert.assertEquals((Object)Optional.of((Object)"/dev/disk4s1"), (Object)info.getDeviceSpec());
        Assert.assertEquals((Object)Optional.of((Object)"/Volumes/Space Path"), (Object)info.getMountPoint());
        Assert.assertFalse((boolean)info.getFsType().isPresent());
        Assert.assertFalse((boolean)info.getOptions().getSize().isPresent());
    }

    @Test
    public void parseMountInfoInvalidOutput() throws Exception {
        UnixMountInfo info = ShellUtils.parseMountInfo((String)"invalid output");
        Assert.assertFalse((boolean)info.getDeviceSpec().isPresent());
        Assert.assertFalse((boolean)info.getMountPoint().isPresent());
        Assert.assertFalse((boolean)info.getFsType().isPresent());
        Assert.assertFalse((boolean)info.getOptions().getSize().isPresent());
    }

    @Test
    public void getMountInfo() throws Exception {
        Assume.assumeTrue((OSUtils.isMacOS() || OSUtils.isLinux() ? 1 : 0) != 0);
        List info = ShellUtils.getUnixMountInfo();
        Assert.assertTrue((info.size() > 0 ? 1 : 0) != 0);
    }
}

