/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.group.provider.IdentityUserGroupsMapping;
import alluxio.util.SecurityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class SecurityUtilsTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void getOwnerFromGrpcClient() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.NOSASL.getAuthName());
        Assert.assertEquals((Object)"", (Object)SecurityUtils.getOwnerFromGrpcClient((AlluxioConfiguration)this.mConfiguration));
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)IdentityUserGroupsMapping.class.getName());
        AuthenticatedClientUser.set((String)"test_client_user");
        Assert.assertEquals((Object)"test_client_user", (Object)SecurityUtils.getOwnerFromGrpcClient((AlluxioConfiguration)this.mConfiguration));
    }

    @Test
    public void getGroupFromGrpcClient() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.NOSASL.getAuthName());
        Assert.assertEquals((Object)"", (Object)SecurityUtils.getGroupFromGrpcClient((AlluxioConfiguration)this.mConfiguration));
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)IdentityUserGroupsMapping.class.getName());
        AuthenticatedClientUser.set((String)"test_client_user");
        Assert.assertEquals((Object)"test_client_user", (Object)SecurityUtils.getGroupFromGrpcClient((AlluxioConfiguration)this.mConfiguration));
    }
}

