/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.util.CommonUtils;
import alluxio.util.LogUtils;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;

public final class LogUtilsTest {
    @Test
    public void truncateShort() throws Exception {
        Assert.assertEquals((Object)"null", (Object)LogUtils.truncateMessageLineLength(null));
        String s = CommonUtils.randomAlphaNumString((int)1);
        Assert.assertEquals((Object)s, (Object)LogUtils.truncateMessageLineLength((Object)s));
        s = CommonUtils.randomAlphaNumString((int)300);
        Assert.assertEquals((Object)s, (Object)LogUtils.truncateMessageLineLength((Object)s));
        for (int i = 0; i < 20; ++i) {
            s = CommonUtils.randomAlphaNumString((int)ThreadLocalRandom.current().nextInt(2, 300));
            Assert.assertEquals((Object)s, (Object)LogUtils.truncateMessageLineLength((Object)s));
        }
    }

    @Test
    public void truncateShortLines() throws Exception {
        for (int i = 0; i < 20; ++i) {
            String s = "";
            for (int lines = 0; lines < ThreadLocalRandom.current().nextInt(5, 10); ++lines) {
                s = s + "\n";
                s = s + CommonUtils.randomAlphaNumString((int)ThreadLocalRandom.current().nextInt(1, 301));
            }
            Assert.assertEquals((Object)s, (Object)LogUtils.truncateMessageLineLength((Object)s));
        }
    }

    @Test
    public void truncateLong() throws Exception {
        for (int i = 0; i < 20; ++i) {
            String s = CommonUtils.randomAlphaNumString((int)ThreadLocalRandom.current().nextInt(301, 302));
            String truncated = LogUtils.truncateMessageLineLength((Object)s);
            Assert.assertTrue((boolean)truncated.startsWith(s.substring(0, 300) + " ..."));
        }
    }

    @Test
    public void truncateLongLines() throws Exception {
        for (int i = 0; i < 20; ++i) {
            String s = "";
            int lines = ThreadLocalRandom.current().nextInt(5, 10);
            for (int j = 0; j < lines; ++j) {
                s = s + "\n";
                s = j % 2 == 0 ? s + CommonUtils.randomAlphaNumString((int)ThreadLocalRandom.current().nextInt(1, 301)) : CommonUtils.randomAlphaNumString((int)ThreadLocalRandom.current().nextInt(301, 302));
            }
            String truncated = LogUtils.truncateMessageLineLength((Object)s);
            String[] expectedLines = s.split("\n");
            String[] actualLines = truncated.split("\n");
            Assert.assertEquals((long)expectedLines.length, (long)actualLines.length);
            for (int j = 0; j < expectedLines.length; ++j) {
                if (expectedLines[j].length() <= 300) {
                    Assert.assertEquals((Object)expectedLines[j], (Object)actualLines[j]);
                    continue;
                }
                Assert.assertTrue((boolean)actualLines[j].startsWith(expectedLines[j].substring(0, 300) + " ..."));
            }
        }
    }

    @Test
    public void truncateSpecificLength() throws Exception {
        String s = CommonUtils.randomAlphaNumString((int)300);
        for (int length = 1; length < 300; ++length) {
            String truncated = LogUtils.truncateMessageLineLength((Object)s, (int)length);
            Assert.assertTrue((boolean)truncated.startsWith(s.substring(0, length) + " ..."));
        }
    }
}

