/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.TestLoggerRule;
import alluxio.util.JvmPauseMonitor;
import java.util.concurrent.CyclicBarrier;
import java.util.function.Supplier;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.reflect.Whitebox;

public final class JvmPauseMonitorTest {
    @Rule
    public TestLoggerRule mLogRule = new TestLoggerRule();
    @Rule
    public ExpectedException mException = ExpectedException.none();

    @Test
    public void pauseMonitorStartStopTest() {
        JvmPauseMonitor mon = new JvmPauseMonitor(100L, 1000L, 500L);
        Supplier<Thread> getThread = () -> (Thread)Whitebox.getInternalState((Object)mon, (String)"mJvmMonitorThread");
        mon.start();
        Assert.assertTrue((boolean)mon.isStarted());
        Assert.assertNotNull((Object)getThread.get());
        mon.stop();
        Assert.assertFalse((boolean)mon.isStarted());
        Assert.assertNull((Object)getThread.get());
    }

    @Test
    public void testNegativeGcSleep() {
        this.mException.expect(IllegalArgumentException.class);
        new JvmPauseMonitor(-1L, 100L, 500L);
    }

    @Test
    public void testNegativeInfoThreshold() {
        this.mException.expect(IllegalArgumentException.class);
        new JvmPauseMonitor(100L, 500L, -1L);
    }

    @Test
    public void testNegativeWarnThreshold() {
        this.mException.expect(IllegalArgumentException.class);
        new JvmPauseMonitor(100L, -1L, 500L);
    }

    @Test
    public void testTinyWarnThreshold() {
        this.mException.expect(IllegalArgumentException.class);
        new JvmPauseMonitor(100L, 50L, 5000L);
    }

    @Test
    public void testMockedInfoPause() throws Exception {
        JvmPauseMonitor mon = (JvmPauseMonitor)Mockito.spy((Object)new JvmPauseMonitor(100L, 1000L, 250L));
        CyclicBarrier before = new CyclicBarrier(2);
        ((JvmPauseMonitor)Mockito.doAnswer(invocation -> {
            Thread.sleep(250L);
            invocation.callRealMethod();
            before.await();
            return null;
        }).when((Object)mon)).sleepMillis(((Long)ArgumentMatchers.any(Long.class)).longValue());
        mon.start();
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)1L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)0L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(250L)));
        Assert.assertTrue((boolean)this.mLogRule.wasLoggedWithLevel("JVM paused.*\n.*\n.*", Level.INFO));
        Assert.assertEquals((long)1L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)2L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)0L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)));
        Assert.assertEquals((long)2L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)3L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)0L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(750L)));
        Assert.assertEquals((long)3L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
    }

    @Test
    public void testMockedWarnPause() throws Exception {
        JvmPauseMonitor mon = (JvmPauseMonitor)Mockito.spy((Object)new JvmPauseMonitor(100L, 200L, 150L));
        CyclicBarrier before = new CyclicBarrier(2);
        ((JvmPauseMonitor)Mockito.doAnswer(invocation -> {
            Thread.sleep(250L);
            invocation.callRealMethod();
            before.await();
            return null;
        }).when((Object)mon)).sleepMillis(((Long)ArgumentMatchers.any(Long.class)).longValue());
        mon.start();
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)1L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)1L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(250L)));
        Assert.assertTrue((boolean)this.mLogRule.wasLoggedWithLevel("JVM paused.*\n.*\n.*", Level.WARN));
        Assert.assertEquals((long)1L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)2L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)2L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(500L)));
        Assert.assertEquals((long)2L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
        before.await();
        while (before.getNumberWaiting() < 1) {
            Thread.sleep(20L);
        }
        Assert.assertEquals((long)3L, (long)mon.getInfoTimeExceeded());
        Assert.assertEquals((long)3L, (long)mon.getWarnTimeExceeded());
        MatcherAssert.assertThat((Object)mon.getTotalExtraTime(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(750L)));
        Assert.assertEquals((long)3L, (long)this.mLogRule.logCount("JVM paused.*\n.*\n.*"));
    }
}

