/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;

public final class FormatUtilsTest {
    @Test
    public void parametersToString() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            String mExpected;
            Object[] mInput;

            public TestCase(String expected, Object[] objs) {
                this.mExpected = expected;
                this.mInput = objs;
            }
        }
        testCases.add(new TestCase("()", null));
        testCases.add(new TestCase("(null)", new Object[]{null}));
        testCases.add(new TestCase("()", new Object[]{""}));
        testCases.add(new TestCase("(foo)", new Object[]{"foo"}));
        testCases.add(new TestCase("(foo, bar)", new Object[]{"foo", "bar"}));
        testCases.add(new TestCase("(foo, , bar)", new Object[]{"foo", "", "bar"}));
        testCases.add(new TestCase("(, foo, )", new Object[]{"", "foo", ""}));
        testCases.add(new TestCase("(, , )", new Object[]{"", "", ""}));
        testCases.add(new TestCase("(1)", new Object[]{1}));
        testCases.add(new TestCase("(1, 2, 3)", new Object[]{1, 2, 3}));
        for (TestCase testCase : testCases) {
            Assert.assertEquals((Object)testCase.mExpected, (Object)FormatUtils.parametersToString((Object[])testCase.mInput));
        }
    }

    @Test
    public void byteBufferToString() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            String mExpected;
            ByteBuffer mInput;

            public TestCase(String expected, ByteBuffer input) {
                this.mExpected = expected;
                this.mInput = input;
            }
        }
        testCases.add(new TestCase("", ByteBuffer.wrap(new byte[0])));
        testCases.add(new TestCase("", ByteBuffer.wrap(new byte[]{0})));
        testCases.add(new TestCase("", ByteBuffer.wrap(new byte[]{0, 0})));
        testCases.add(new TestCase("", ByteBuffer.wrap(new byte[]{0, 0, 0})));
        testCases.add(new TestCase("1", ByteBuffer.wrap(new byte[]{0, 0, 0, 1})));
        testCases.add(new TestCase("1", ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 0})));
        testCases.add(new TestCase("1", ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 0, 0})));
        testCases.add(new TestCase("1", ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 0, 0, 0})));
        testCases.add(new TestCase("1 2", ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 0, 0, 0, 2})));
        for (TestCase testCase : testCases) {
            Assert.assertEquals((Object)testCase.mExpected, (Object)FormatUtils.byteBufferToString((ByteBuffer)testCase.mInput));
        }
    }

    @Test
    public void byteArrayToHexString() {
        Assert.assertEquals((Object)"", (Object)FormatUtils.byteArrayToHexString((byte[])new byte[0]));
        Assert.assertEquals((Object)"0x01", (Object)FormatUtils.byteArrayToHexString((byte[])new byte[]{1}));
        Assert.assertEquals((Object)"0x01 0xac", (Object)FormatUtils.byteArrayToHexString((byte[])new byte[]{1, -84}));
        Assert.assertEquals((Object)"01ac", (Object)FormatUtils.byteArrayToHexString((byte[])new byte[]{1, -84}, (String)"", (String)""));
    }

    @Test
    public void formatTimeTakenMs() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            Pattern mExpected;
            String mInputMessage;

            public TestCase(String expectedRE, String inputMessage) {
                this.mExpected = Pattern.compile(expectedRE);
                this.mInputMessage = inputMessage;
            }
        }
        testCases.add(new TestCase("^Task A took (.*) ms.$", "Task A"));
        testCases.add(new TestCase("^Task B took (.*) ms.$", "Task B"));
        long delta = 100L;
        for (TestCase testCase : testCases) {
            String result = FormatUtils.formatTimeTakenMs((long)(CommonUtils.getCurrentMs() - delta), (String)testCase.mInputMessage);
            Matcher match = testCase.mExpected.matcher(result);
            Assert.assertTrue((boolean)match.matches());
            Assert.assertTrue((delta <= Long.parseLong(match.group(1)) ? 1 : 0) != 0);
            Assert.assertTrue((Long.parseLong(match.group(1)) <= 2L * delta ? 1 : 0) != 0);
        }
    }

    @Test
    public void formatTimeTakenNs() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            Pattern mExpected;
            String mInputMessage;

            public TestCase(String expectedRE, String inputMessage) {
                this.mExpected = Pattern.compile(expectedRE);
                this.mInputMessage = inputMessage;
            }
        }
        testCases.add(new TestCase("^Task A took (.*) ns.$", "Task A"));
        testCases.add(new TestCase("^Task B took (.*) ns.$", "Task B"));
        long delta = 100000000L;
        for (TestCase testCase : testCases) {
            String result = FormatUtils.formatTimeTakenNs((long)(System.nanoTime() - delta), (String)testCase.mInputMessage);
            Matcher match = testCase.mExpected.matcher(result);
            Assert.assertTrue((boolean)match.matches());
            Assert.assertTrue((delta <= Long.parseLong(match.group(1)) ? 1 : 0) != 0);
            Assert.assertTrue((Long.parseLong(match.group(1)) <= 2L * delta ? 1 : 0) != 0);
        }
    }

    @Test
    public void getSizeFromBytes() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            String mExpected;
            long mInput;

            public TestCase(String expected, long input) {
                this.mExpected = expected;
                this.mInput = input;
            }
        }
        testCases.add(new TestCase("4B", 4L));
        testCases.add(new TestCase("8B", 8L));
        testCases.add(new TestCase("4096B", 4096L));
        testCases.add(new TestCase("8.00KB", 8192L));
        testCases.add(new TestCase("4096.00KB", 0x400000L));
        testCases.add(new TestCase("8.00MB", 0x800000L));
        testCases.add(new TestCase("4096.00MB", 0x100000000L));
        testCases.add(new TestCase("8.00GB", 0x200000000L));
        testCases.add(new TestCase("4096.00GB", 0x40000000000L));
        testCases.add(new TestCase("8.00TB", 0x80000000000L));
        testCases.add(new TestCase("4096.00TB", 0x10000000000000L));
        testCases.add(new TestCase("8.00PB", 0x20000000000000L));
        testCases.add(new TestCase("4096.00PB", 0x4000000000000000L));
        for (TestCase testCase : testCases) {
            Assert.assertEquals((Object)testCase.mExpected, (Object)FormatUtils.getSizeFromBytes((long)testCase.mInput));
        }
    }

    @Test
    public void parseSpaceSize() {
        long k;
        long max = 10240L;
        for (k = 0L; k < max; ++k) {
            Assert.assertEquals((long)(k / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "b")));
            Assert.assertEquals((long)(k / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "B")));
            Assert.assertEquals((long)(k / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "")));
        }
        for (k = 0L; k < max; ++k) {
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "kb")));
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "Kb")));
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "KB")));
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "kB")));
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "k")));
            Assert.assertEquals((long)(k * 1024L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "K")));
        }
        for (k = 0L; k < max; ++k) {
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "mb")));
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "Mb")));
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "MB")));
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "mB")));
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "m")));
            Assert.assertEquals((long)(k * 0x100000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "M")));
        }
        for (k = 0L; k < max; ++k) {
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "gb")));
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "Gb")));
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "GB")));
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "gB")));
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "g")));
            Assert.assertEquals((long)(k * 0x40000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "G")));
        }
        for (k = 0L; k < max; ++k) {
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "tb")));
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "Tb")));
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "TB")));
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "tB")));
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "t")));
            Assert.assertEquals((long)(k * 0x10000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "T")));
        }
        for (k = 0L; k < 8192L; ++k) {
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "pb")));
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "Pb")));
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "PB")));
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "pB")));
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "p")));
            Assert.assertEquals((long)(k * 0x4000000000000L / 10L), (long)FormatUtils.parseSpaceSize((String)((double)k / 10.0 + "P")));
        }
    }

    @Test
    public void formatPermission() {
        Assert.assertEquals((Object)"-rw-rw-rw-", (Object)FormatUtils.formatMode((short)438, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"drw-rw-rw-", (Object)FormatUtils.formatMode((short)438, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)"-rwxrwxrwx", (Object)FormatUtils.formatMode((short)511, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"drwxrwxrwx", (Object)FormatUtils.formatMode((short)511, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)"-r--r--r--", (Object)FormatUtils.formatMode((short)292, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"dr--r--r--", (Object)FormatUtils.formatMode((short)292, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)"-r-xr-xr-x", (Object)FormatUtils.formatMode((short)365, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"dr-xr-xr-x", (Object)FormatUtils.formatMode((short)365, (boolean)true, (boolean)false));
        Assert.assertEquals((Object)"-rwxr-xr--", (Object)FormatUtils.formatMode((short)492, (boolean)false, (boolean)false));
        Assert.assertEquals((Object)"drwxr-xr--", (Object)FormatUtils.formatMode((short)492, (boolean)true, (boolean)false));
    }

    @Test
    public void formatPermissionExtendedAcl() {
        Assert.assertEquals((Object)"-rw-rw-rw-+", (Object)FormatUtils.formatMode((short)438, (boolean)false, (boolean)true));
        Assert.assertEquals((Object)"drw-rw-rw-+", (Object)FormatUtils.formatMode((short)438, (boolean)true, (boolean)true));
        Assert.assertEquals((Object)"-rwxrwxrwx+", (Object)FormatUtils.formatMode((short)511, (boolean)false, (boolean)true));
        Assert.assertEquals((Object)"drwxrwxrwx+", (Object)FormatUtils.formatMode((short)511, (boolean)true, (boolean)true));
    }
}

