/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.util.ConfigurationUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public final class ConfigurationUtilsTest {
    @Test
    public void getSingleMasterRpcAddress() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.MASTER_HOSTNAME, (Object)"testhost", (Object)PropertyKey.MASTER_RPC_PORT, (Object)"1000"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("testhost", 1000)), (Object)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getMasterRpcAddresses() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.MASTER_RPC_ADDRESSES, (Object)"host1:99,host2:100"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("host1", 99), InetSocketAddress.createUnresolved("host2", 100)), (Object)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getMasterRpcAddressesFallback() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.MASTER_EMBEDDED_JOURNAL_ADDRESSES, (Object)"host1:99,host2:100", (Object)PropertyKey.MASTER_RPC_PORT, (Object)"50"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("host1", 50), InetSocketAddress.createUnresolved("host2", 50)), (Object)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getMasterRpcAddressesDefault() {
        AlluxioConfiguration conf = this.createConf(Collections.emptyMap());
        String host = NetworkAddressUtils.getLocalHostName((int)5000);
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved(host, 19998)), (Object)ConfigurationUtils.getMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getSingleJobMasterRpcAddress() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.JOB_MASTER_HOSTNAME, (Object)"testhost", (Object)PropertyKey.JOB_MASTER_RPC_PORT, (Object)"1000"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("testhost", 1000)), (Object)ConfigurationUtils.getJobMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getJobMasterRpcAddresses() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.JOB_MASTER_RPC_ADDRESSES, (Object)"host1:99,host2:100"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("host1", 99), InetSocketAddress.createUnresolved("host2", 100)), (Object)ConfigurationUtils.getJobMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getJobMasterRpcAddressesMasterRpcFallback() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.MASTER_RPC_ADDRESSES, (Object)"host1:99,host2:100", (Object)PropertyKey.JOB_MASTER_RPC_PORT, (Object)"50"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("host1", 50), InetSocketAddress.createUnresolved("host2", 50)), (Object)ConfigurationUtils.getJobMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getJobMasterRpcAddressesServerFallback() {
        AlluxioConfiguration conf = this.createConf((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.JOB_MASTER_EMBEDDED_JOURNAL_ADDRESSES, (Object)"host1:99,host2:100", (Object)PropertyKey.JOB_MASTER_RPC_PORT, (Object)"50"));
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved("host1", 50), InetSocketAddress.createUnresolved("host2", 50)), (Object)ConfigurationUtils.getJobMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void getJobMasterRpcAddressesDefault() {
        AlluxioConfiguration conf = this.createConf(Collections.emptyMap());
        String host = NetworkAddressUtils.getLocalHostName((int)5000);
        Assert.assertEquals(Arrays.asList(InetSocketAddress.createUnresolved(host, 20001)), (Object)ConfigurationUtils.getJobMasterRpcAddresses((AlluxioConfiguration)conf));
    }

    @Test
    public void testMasterNotConfiguredMessage() {
        Assert.assertEquals((String)"Messages should be the same", (Object)"Cannot run test service; Unable to determine master address. Please modify alluxio-site.properties to either set alluxio.master.hostname, configure zookeeper with alluxio.zookeeper.enabled=true and alluxio.zookeeper.address=[comma-separated zookeeper master addresses], or utilize internal HA by setting alluxio.master.embedded.journal.addresses=[comma-separated alluxio master addresses]", (Object)ConfigurationUtils.getMasterHostNotConfiguredMessage((String)"test service"));
        Assert.assertEquals((String)"Messages should be the same", (Object)"Cannot run test service 2; Unable to determine job master address. Please modify alluxio-site.properties to either set alluxio.job.master.hostname, configure zookeeper with alluxio.zookeeper.enabled=true and alluxio.zookeeper.address=[comma-separated zookeeper master addresses], or utilize internal HA by setting alluxio.job.master.embedded.journal.addresses=[comma-separated alluxio job master addresses]", (Object)ConfigurationUtils.getJobMasterHostNotConfiguredMessage((String)"test service 2"));
    }

    @Test
    public void parseAsList() {
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a"}), (Object)ConfigurationUtils.parseAsList((String)"a", (String)","));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (Object)ConfigurationUtils.parseAsList((String)"a,b,c", (String)","));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}), (Object)ConfigurationUtils.parseAsList((String)" a , b , c ", (String)","));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a,b,c"}), (Object)ConfigurationUtils.parseAsList((String)"a,b,c", (String)";"));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "c"}), (Object)ConfigurationUtils.parseAsList((String)",,a,,c,,", (String)","));
    }

    private AlluxioConfiguration createConf(Map<PropertyKey, String> properties) {
        AlluxioProperties props = ConfigurationUtils.defaults();
        for (PropertyKey key : properties.keySet()) {
            props.set(key, properties.get(key));
        }
        return new InstancedConfiguration(props);
    }
}

