/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.security.group.CachedGroupMapping;
import alluxio.security.group.GroupMappingService;
import alluxio.util.CommonUtils;
import alluxio.util.ShellUtils;
import alluxio.util.WaitForOptions;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CommonUtils.class, ShellUtils.class, GroupMappingService.Factory.class})
public class CommonUtilsTest {
    @Test
    public void convertMsToClockTime() {
        Assert.assertEquals((Object)"0 day(s), 0 hour(s), 0 minute(s), and 0 second(s)", (Object)CommonUtils.convertMsToClockTime((long)10L));
        Assert.assertEquals((Object)"0 day(s), 0 hour(s), 0 minute(s), and 1 second(s)", (Object)CommonUtils.convertMsToClockTime((long)TimeUnit.SECONDS.toMillis(1L)));
        Assert.assertEquals((Object)"0 day(s), 0 hour(s), 1 minute(s), and 0 second(s)", (Object)CommonUtils.convertMsToClockTime((long)TimeUnit.MINUTES.toMillis(1L)));
        Assert.assertEquals((Object)"0 day(s), 0 hour(s), 1 minute(s), and 30 second(s)", (Object)CommonUtils.convertMsToClockTime((long)(TimeUnit.MINUTES.toMillis(1L) + TimeUnit.SECONDS.toMillis(30L))));
        Assert.assertEquals((Object)"0 day(s), 1 hour(s), 0 minute(s), and 0 second(s)", (Object)CommonUtils.convertMsToClockTime((long)TimeUnit.HOURS.toMillis(1L)));
        long time = TimeUnit.DAYS.toMillis(1L) + TimeUnit.HOURS.toMillis(4L) + TimeUnit.MINUTES.toMillis(10L) + TimeUnit.SECONDS.toMillis(45L);
        String out = CommonUtils.convertMsToClockTime((long)time);
        Assert.assertEquals((Object)"1 day(s), 4 hour(s), 10 minute(s), and 45 second(s)", (Object)out);
    }

    @Test
    public void getCurrentMsAndSleepMs() {
        long delta = 100L;
        long startTime = CommonUtils.getCurrentMs();
        CommonUtils.sleepMs((long)delta);
        long currentTime = CommonUtils.getCurrentMs();
        Assert.assertTrue((startTime + delta <= currentTime ? 1 : 0) != 0);
        Assert.assertTrue((currentTime <= 2L * delta + startTime ? 1 : 0) != 0);
    }

    @Test
    public void getTmpDir() {
        String singleDir = "/tmp";
        List<String> singleDirList = Arrays.asList("/tmp");
        Assert.assertEquals((Object)singleDir, (Object)CommonUtils.getTmpDir(singleDirList));
        List<String> multiDirs = Arrays.asList("/tmp1", "/tmp2", "/tmp3");
        HashSet<String> results = new HashSet<String>();
        for (int i = 0; i < 100 || results.size() != multiDirs.size(); ++i) {
            results.add(CommonUtils.getTmpDir(multiDirs));
        }
        Assert.assertEquals(new HashSet<String>(multiDirs), results);
    }

    @Test
    public void argsToString() {
        Assert.assertEquals((Object)"", (Object)CommonUtils.argsToString((String)".", (Object[])new String[]{""}));
        Assert.assertEquals((Object)"foo", (Object)CommonUtils.argsToString((String)".", (Object[])new String[]{"foo"}));
        Assert.assertEquals((Object)"foo,bar", (Object)CommonUtils.argsToString((String)",", (Object[])new String[]{"foo", "bar"}));
        Assert.assertEquals((Object)"1", (Object)CommonUtils.argsToString((String)"", (Object[])new Integer[]{1}));
        Assert.assertEquals((Object)"1;2;3", (Object)CommonUtils.argsToString((String)";", (Object[])new Integer[]{1, 2, 3}));
    }

    @Test
    public void listToString() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            List<Object> mInput;
            String mExpected;

            public TestCase(String expected, Object ... objs) {
                this.mExpected = expected;
                this.mInput = Arrays.asList(objs);
            }
        }
        testCases.add(new TestCase("", new Object[0]));
        testCases.add(new TestCase("foo", "foo"));
        testCases.add(new TestCase("foo bar", "foo", "bar"));
        testCases.add(new TestCase("1", 1));
        testCases.add(new TestCase("1 2 3", 1, 2, 3));
        for (TestCase testCase : testCases) {
            Assert.assertEquals((Object)testCase.mExpected, (Object)CommonUtils.listToString(testCase.mInput));
        }
    }

    @Test
    public void toStringArray() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            String[] mExpected;

            public TestCase(String ... strings) {
                this.mExpected = strings;
            }
        }
        testCases.add(new TestCase(new String[0]));
        testCases.add(new TestCase("foo"));
        testCases.add(new TestCase("foo", "bar"));
        for (TestCase testCase : testCases) {
            ArrayList input = new ArrayList();
            Collections.addAll(input, testCase.mExpected);
            String[] got = CommonUtils.toStringArray(input);
            Assert.assertEquals((long)testCase.mExpected.length, (long)got.length);
            for (int k = 0; k < got.length; ++k) {
                Assert.assertEquals((Object)testCase.mExpected[k], (Object)got[k]);
            }
        }
    }

    @Test
    public void createNewClassInstance() {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        class TestCase {
            Class<?> mCls;
            Class<?>[] mCtorClassArgs;
            Object[] mCtorArgs;
            String mExpected;

            public TestCase(String expected, Class<?> cls, Class<?>[] ctorClassArgs, Object ... ctorArgs) {
                this.mCls = cls;
                this.mCtorClassArgs = ctorClassArgs;
                this.mCtorArgs = ctorArgs;
                this.mExpected = expected;
            }
        }
        testCases.add(new TestCase("hello", TestClassA.class, null, new Object[0]));
        testCases.add(new TestCase("1", TestClassB.class, new Class[]{Integer.TYPE}, 1));
        for (TestCase testCase : testCases) {
            Object o = CommonUtils.createNewClassInstance(testCase.mCls, (Class[])testCase.mCtorClassArgs, (Object[])testCase.mCtorArgs);
            Assert.assertEquals((Object)o.toString(), (Object)testCase.mExpected);
        }
    }

    private void setupShellMocks(String username, List<String> groups) throws IOException {
        PowerMockito.mockStatic(ShellUtils.class, (Class[])new Class[0]);
        String shellResult = "";
        for (String group : groups) {
            shellResult = shellResult + " " + group;
        }
        PowerMockito.when((Object)ShellUtils.execCommand((String[])ShellUtils.getGroupsForUserCommand((String)((String)Mockito.eq((Object)username))))).thenReturn((Object)shellResult);
    }

    @Test
    public void userGroup() throws Throwable {
        String userName = "alluxio-user1";
        String userGroup1 = "alluxio-user1-group1";
        String userGroup2 = "alluxio-user1-group2";
        ArrayList<String> userGroups = new ArrayList<String>();
        userGroups.add(userGroup1);
        userGroups.add(userGroup2);
        this.setupShellMocks(userName, userGroups);
        List groups = CommonUtils.getUnixGroups((String)userName);
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)groups.size(), (long)2L);
        Assert.assertEquals(groups.get(0), (Object)userGroup1);
        Assert.assertEquals(groups.get(1), (Object)userGroup2);
    }

    @Test
    public void getGroups() throws Throwable {
        InstancedConfiguration conf = ConfigurationTestUtils.defaults();
        String userName = "alluxio-user1";
        String userGroup1 = "alluxio-user1-group1";
        String userGroup2 = "alluxio-user1-group2";
        ArrayList<String> userGroups = new ArrayList<String>();
        userGroups.add(userGroup1);
        userGroups.add(userGroup2);
        CachedGroupMapping cachedGroupService = (CachedGroupMapping)PowerMockito.mock(CachedGroupMapping.class);
        PowerMockito.when((Object)cachedGroupService.getGroups(Mockito.anyString())).thenReturn((Object)Lists.newArrayList((Object[])new String[]{userGroup1, userGroup2}));
        PowerMockito.mockStatic(GroupMappingService.Factory.class, (Class[])new Class[0]);
        Mockito.when((Object)GroupMappingService.Factory.get((AlluxioConfiguration)conf)).thenReturn((Object)cachedGroupService);
        List groups = CommonUtils.getGroups((String)userName, (AlluxioConfiguration)conf);
        Assert.assertEquals(Arrays.asList(userGroup1, userGroup2), (Object)groups);
        String primaryGroup = CommonUtils.getPrimaryGroupName((String)userName, (AlluxioConfiguration)conf);
        Assert.assertNotNull((Object)primaryGroup);
        Assert.assertEquals((Object)userGroup1, (Object)primaryGroup);
    }

    @Test
    public void stripSuffixIfPresent() throws Exception {
        String[] inputs = new String[]{"ufs://bucket/", "ufs://bucket/", "ufs://bucket/file_SUCCESS", "ufs://bucket-2/dir/file/", "dir/file", "/dir/file/", "ufs://bucket/file_$folder"};
        String[] suffixToStrip = new String[]{"ufs://bucket/", "/", "_SUCCESS", "/", "/", "/", "_$folder"};
        String[] results = new String[]{"", "ufs://bucket", "ufs://bucket/file", "ufs://bucket-2/dir/file", "dir/file", "/dir/file", "ufs://bucket/file"};
        for (int i = 0; i < inputs.length; ++i) {
            Assert.assertEquals((Object)results[i], (Object)CommonUtils.stripSuffixIfPresent((String)inputs[i], (String)suffixToStrip[i]));
        }
    }

    @Test
    public void stripPrefixIfPresent() throws Exception {
        String[] inputs = new String[]{"ufs://bucket/", "ufs://bucket", "ufs://bucket/", "ufs://bucket-2/dir/file", "dir/file", "/dir/file", "ufs://bucket/file"};
        String[] prefixToStrip = new String[]{"ufs://bucket/", "ufs://bucket/", "", "ufs://bucket-2/", "ufs://bucket", "/", "ufs://bucket/"};
        String[] results = new String[]{"", "ufs://bucket", "ufs://bucket/", "dir/file", "dir/file", "dir/file", "file"};
        for (int i = 0; i < inputs.length; ++i) {
            Assert.assertEquals((Object)results[i], (Object)CommonUtils.stripPrefixIfPresent((String)inputs[i], (String)prefixToStrip[i]));
        }
    }

    @Test
    public void stripLeadingAndTrailingQuotes() throws Exception {
        Assert.assertEquals((Object)"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)""));
        Assert.assertEquals((Object)"\"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\""));
        Assert.assertEquals((Object)"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"\""));
        Assert.assertEquals((Object)"\"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"\"\""));
        Assert.assertEquals((Object)"\"\"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"\"\"\""));
        Assert.assertEquals((Object)"noquote", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"noquote"));
        Assert.assertEquals((Object)"\"singlequote", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"singlequote"));
        Assert.assertEquals((Object)"singlequote\"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"singlequote\""));
        Assert.assertEquals((Object)"quoted", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"quoted\""));
        Assert.assertEquals((Object)"\"quoted\"", (Object)CommonUtils.stripLeadingAndTrailingQuotes((String)"\"\"quoted\"\""));
    }

    @Test
    public void getValueFromStaticMapping() throws Exception {
        String mapping = "k=v; a=a; alice=bob; id1=userA; foo=bar";
        Assert.assertEquals((Object)"v", (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"k"));
        Assert.assertEquals((Object)"a", (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"a"));
        Assert.assertEquals((Object)"bob", (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"alice"));
        Assert.assertEquals((Object)"userA", (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"id1"));
        Assert.assertEquals((Object)"bar", (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"foo"));
        Assert.assertEquals(null, (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)""));
        Assert.assertEquals(null, (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"/"));
        Assert.assertEquals(null, (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"v"));
        Assert.assertEquals(null, (Object)CommonUtils.getValueFromStaticMapping((String)mapping, (String)"nonexist"));
    }

    @Test
    public void invokeAllSuccess() throws Exception {
        int numTasks = 5;
        final CyclicBarrier b = new CyclicBarrier(numTasks);
        final AtomicInteger completed = new AtomicInteger();
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < numTasks; ++i) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    b.await();
                    completed.incrementAndGet();
                    return null;
                }
            });
        }
        CommonUtils.invokeAll(tasks, (long)10000L);
        Assert.assertEquals((long)numTasks, (long)completed.get());
    }

    @Test
    public void invokeAllHang() throws Exception {
        int numTasks = 5;
        ArrayList<2> tasks = new ArrayList<2>();
        for (int i = 0; i < numTasks; ++i) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Thread.sleep(10000L);
                    return null;
                }
            });
        }
        try {
            CommonUtils.invokeAll(tasks, (long)50L);
            Assert.fail((String)"Expected a timeout exception");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void invokeAllExceptionAndHang() throws Exception {
        long start = System.currentTimeMillis();
        RuntimeException testException = new RuntimeException("failed");
        try {
            CommonUtils.invokeAll(Arrays.asList(() -> {
                Thread.sleep(10000L);
                return null;
            }, () -> {
                throw testException;
            }), (long)5000L);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)testException, (Object)e.getCause());
        }
        Assert.assertThat((String)"invokeAll should exit early if one of the tasks throws an exception", (Object)(System.currentTimeMillis() - start), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(2000L)));
    }

    @Test
    public void invokeAllPropagatesException() throws Exception {
        int numTasks = 5;
        final AtomicInteger id = new AtomicInteger();
        ArrayList<3> tasks = new ArrayList<3>();
        final Exception testException = new Exception("test message");
        for (int i = 0; i < numTasks; ++i) {
            tasks.add(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    int myId = id.incrementAndGet();
                    if (myId == 3) {
                        throw testException;
                    }
                    return null;
                }
            });
        }
        try {
            CommonUtils.invokeAll(tasks, (long)2000L);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)testException, (Object)e.getCause());
        }
    }

    @Test
    public void invokeAllPropagatesExceptionWithTimeout() throws Exception {
        int numTasks = 5;
        AtomicInteger id = new AtomicInteger();
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        Exception testException = new Exception("test message");
        for (int i = 0; i < numTasks; ++i) {
            tasks.add(() -> {
                int myId = id.incrementAndGet();
                if (myId == 3) {
                    throw testException;
                }
                Thread.sleep(10000L);
                return null;
            });
        }
        try {
            CommonUtils.invokeAll(tasks, (long)500L);
            Assert.fail((String)"Expected an exception to be thrown");
        }
        catch (ExecutionException e) {
            Assert.assertSame((Object)testException, (Object)e.getCause());
        }
    }

    @Test
    public void waitForFirstTry() throws Exception {
        this.testNthSuccess(1);
    }

    @Test
    public void waitForSecondTry() throws Exception {
        this.testNthSuccess(2);
    }

    @Test
    public void waitForFiftyTry() throws Exception {
        this.testNthSuccess(5);
    }

    private void testNthSuccess(int n) throws Exception {
        CountCondition cond = new CountCondition(n);
        int intervalMs = 10;
        WaitForOptions opts = WaitForOptions.defaults().setInterval(intervalMs);
        long start = System.currentTimeMillis();
        CommonUtils.waitFor((String)"", (Supplier)cond, (WaitForOptions)opts);
        long durationMs = System.currentTimeMillis() - start;
        Assert.assertThat((Object)((int)durationMs), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf((n - 1) * intervalMs)));
        Assert.assertEquals((long)n, (long)cond.invocations());
    }

    @Test(expected=TimeoutException.class)
    public void waitForTimeout() throws Exception {
        CountCondition cond = new CountCondition(100);
        WaitForOptions opts = WaitForOptions.defaults().setInterval(3).setTimeoutMs(100);
        CommonUtils.waitFor((String)"", (Supplier)cond, (WaitForOptions)opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void interruptInvokeAll() throws Exception {
        long longWaitMs = 1000000L;
        ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
        for (int i = 0; i < 10; ++i) {
            tasks.add(() -> {
                CommonUtils.sleepMs((long)longWaitMs);
                return null;
            });
        }
        Thread waiting = new Thread(() -> {
            try {
                CommonUtils.invokeAll((List)tasks, (long)longWaitMs);
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception e) {
                Assert.fail((String)("invokeAll threw unexpected exception: " + e));
            }
        });
        try {
            waiting.start();
            waiting.interrupt();
        }
        finally {
            waiting.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void invokeAllTimeoutCleanup() throws Exception {
        long longWaitMs = 1000000L;
        ThreadPoolExecutor service = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        try {
            ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
            for (int i = 0; i < 10; ++i) {
                tasks.add(() -> {
                    CommonUtils.sleepMs((long)longWaitMs);
                    return null;
                });
            }
            try {
                CommonUtils.invokeAll((ExecutorService)service, tasks, (long)10L);
                Assert.fail((String)"invokeAll is expected to timeout, not succeed");
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            CommonUtils.waitFor((String)"all threads to stop after timeout", () -> service.getActiveCount() == 0, (WaitForOptions)WaitForOptions.defaults().setInterval(10).setTimeoutMs(1000));
        }
        finally {
            service.shutdownNow();
        }
    }

    @Test
    public void recursiveList() throws Exception {
        File tmpDirFile = Files.createTempDir();
        tmpDirFile.deleteOnExit();
        HashSet<File> allFiles = new HashSet<File>();
        for (int i = 0; i < 10; ++i) {
            this.createFileOrDir(tmpDirFile, i, new Random(), allFiles);
        }
        List listedFiles = CommonUtils.recursiveListLocalDir((File)tmpDirFile);
        Assert.assertEquals(allFiles, new HashSet(listedFiles));
    }

    @Test
    public void parseVersion() throws Exception {
        Assert.assertEquals((long)8L, (long)CommonUtils.parseMajorVersion((String)"1.8.0"));
        Assert.assertEquals((long)11L, (long)CommonUtils.parseMajorVersion((String)"11.0.1"));
        Assert.assertEquals((long)9L, (long)CommonUtils.parseMajorVersion((String)"9.0.1"));
    }

    private void createFileOrDir(File dir, int index, Random rand, Set<File> files) throws IOException {
        int childType = rand.nextInt(2);
        File child = new File(dir, index + "");
        if (childType == 1) {
            child.mkdir();
            this.createFileOrDir(child, index, rand, files);
        } else {
            child.createNewFile();
            files.add(child);
        }
    }

    private static class CountCondition
    implements Supplier<Boolean> {
        private final int mTarget;
        private int mCount = 0;

        public CountCondition(int target) {
            this.mTarget = target;
        }

        @Override
        public Boolean get() {
            return ++this.mCount >= this.mTarget;
        }

        private int invocations() {
            return this.mCount;
        }
    }

    static class TestClassB {
        int mX;

        public TestClassB(int x) {
            this.mX = x;
        }

        public String toString() {
            return Integer.toString(this.mX);
        }
    }

    static class TestClassA {
        public String toString() {
            return "hello";
        }
    }
}

