/*
 * Decompiled with CFR 0.152.
 */
package alluxio.uri;

import alluxio.uri.Authority;
import alluxio.uri.MultiMasterAuthority;
import alluxio.uri.NoAuthority;
import alluxio.uri.SingleMasterAuthority;
import alluxio.uri.UnknownAuthority;
import alluxio.uri.ZookeeperAuthority;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class AuthorityTest {
    @Test
    public void authorityFromStringTest() {
        Assert.assertTrue((boolean)(Authority.fromString((String)"localhost:19998") instanceof SingleMasterAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"127.0.0.1:19998") instanceof SingleMasterAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@host:2181") instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@host1:2181,127.0.0.2:2181,12.43.214.53:2181") instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@host1:2181;host2:2181;host3:2181") instanceof ZookeeperAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"") instanceof NoAuthority));
        Assert.assertTrue((boolean)(Authority.fromString(null) instanceof NoAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"localhost") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"f3,321:sad") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"localhost:") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"127.0.0.1:19998,") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"localhost:19998:8080") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"localhost:asdsad") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@;") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@localhost") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@127.0.0.1:port") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@127.0.0.1:2181,") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)"zk@127.0.0.1:2181,localhost") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)",,,") instanceof UnknownAuthority));
        Assert.assertTrue((boolean)(Authority.fromString((String)";;;") instanceof UnknownAuthority));
    }

    @Test
    public void singleMasterAuthorityTest() {
        SingleMasterAuthority authority = (SingleMasterAuthority)Authority.fromString((String)"localhost:19998");
        Assert.assertEquals((Object)"localhost:19998", (Object)authority.toString());
        Assert.assertEquals((Object)"localhost", (Object)authority.getHost());
        Assert.assertEquals((long)19998L, (long)authority.getPort());
    }

    @Test
    public void multiMasterAuthorityTest() {
        MultiMasterAuthority authority = (MultiMasterAuthority)Authority.fromString((String)"host1:19998,host2:19998,host3:19998");
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)authority.toString());
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)authority.getMasterAddresses());
        authority = (MultiMasterAuthority)Authority.fromString((String)"127.0.0.1:213,127.0.0.2:532423,127.0.0.3:3213");
        Assert.assertEquals((Object)"127.0.0.1:213,127.0.0.2:532423,127.0.0.3:3213", (Object)authority.toString());
        Assert.assertEquals((Object)"127.0.0.1:213,127.0.0.2:532423,127.0.0.3:3213", (Object)authority.getMasterAddresses());
        authority = (MultiMasterAuthority)Authority.fromString((String)"host1:19998;host2:19998;host3:19998");
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)authority.getMasterAddresses());
        authority = (MultiMasterAuthority)Authority.fromString((String)"host1:19998+host2:19998+host3:19998");
        Assert.assertEquals((Object)"host1:19998,host2:19998,host3:19998", (Object)authority.getMasterAddresses());
        Assert.assertFalse((boolean)(Authority.fromString((String)"localhost:19998") instanceof MultiMasterAuthority));
        Assert.assertFalse((boolean)(Authority.fromString((String)"localhost:abc,127.0.0.1:dsa") instanceof MultiMasterAuthority));
        Assert.assertFalse((boolean)(Authority.fromString((String)",,,") instanceof MultiMasterAuthority));
        Assert.assertFalse((boolean)(Authority.fromString((String)";;;") instanceof MultiMasterAuthority));
        Assert.assertFalse((boolean)(Authority.fromString((String)"+++") instanceof MultiMasterAuthority));
    }

    @Test
    public void zookeeperAuthorityTest() {
        ZookeeperAuthority authority = (ZookeeperAuthority)Authority.fromString((String)"zk@host:2181");
        Assert.assertEquals((Object)"zk@host:2181", (Object)authority.toString());
        Assert.assertEquals((Object)"host:2181", (Object)authority.getZookeeperAddress());
        authority = (ZookeeperAuthority)Authority.fromString((String)"zk@127.0.0.1:2181,127.0.0.2:2181,127.0.0.3:2181");
        Assert.assertEquals((Object)"zk@127.0.0.1:2181,127.0.0.2:2181,127.0.0.3:2181", (Object)authority.toString());
        Assert.assertEquals((Object)"127.0.0.1:2181,127.0.0.2:2181,127.0.0.3:2181", (Object)authority.getZookeeperAddress());
        authority = (ZookeeperAuthority)Authority.fromString((String)"zk@host1:2181;host2:2181;host3:2181");
        Assert.assertEquals((Object)"zk@host1:2181,host2:2181,host3:2181", (Object)authority.toString());
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)authority.getZookeeperAddress());
        authority = (ZookeeperAuthority)Authority.fromString((String)"zk@host1:2181+host2:2181+host3:2181");
        Assert.assertEquals((Object)"zk@host1:2181,host2:2181,host3:2181", (Object)authority.toString());
        Assert.assertEquals((Object)"host1:2181,host2:2181,host3:2181", (Object)authority.getZookeeperAddress());
    }

    @Test
    public void mixedDelimiters() {
        String normalized = "a:0,b:0,c:0";
        for (String test : Arrays.asList("zk@a:0;b:0+c:0", "zk@a:0,b:0;c:0", "zk@a:0+b:0,c:0")) {
            Assert.assertEquals((Object)normalized, (Object)((ZookeeperAuthority)Authority.fromString((String)test)).getZookeeperAddress());
        }
    }
}

