/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authorization.Mode;
import alluxio.security.group.provider.IdentityUserGroupsMapping;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ModeUtils;
import com.google.common.testing.EqualsTester;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class MkdirsOptionsTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    @Test
    public void defaults() throws IOException {
        MkdirsOptions options = MkdirsOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        Assert.assertTrue((boolean)options.getCreateParent());
        Assert.assertNull((Object)options.getOwner());
        Assert.assertNull((Object)options.getGroup());
        String umask = this.mConfiguration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK);
        Assert.assertEquals((Object)ModeUtils.applyDirectoryUMask((Mode)Mode.defaults(), (String)umask), (Object)options.getMode());
    }

    @Test
    public void securityEnabled() throws IOException {
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        conf.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        conf.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"foo");
        conf.set(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)IdentityUserGroupsMapping.class.getName());
        MkdirsOptions options = MkdirsOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        Assert.assertTrue((boolean)options.getCreateParent());
        Assert.assertNull((Object)options.getOwner());
        Assert.assertNull((Object)options.getGroup());
        String umask = this.mConfiguration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK);
        Assert.assertEquals((Object)ModeUtils.applyDirectoryUMask((Mode)Mode.defaults(), (String)umask), (Object)options.getMode());
    }

    @Test
    public void fields() {
        Random random = new Random();
        boolean createParent = random.nextBoolean();
        String owner = CommonUtils.randomAlphaNumString((int)10);
        String group = CommonUtils.randomAlphaNumString((int)10);
        Mode mode = new Mode((short)random.nextInt());
        MkdirsOptions options = MkdirsOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        options.setCreateParent(createParent);
        options.setOwner(owner);
        options.setGroup(group);
        options.setMode(mode);
        Assert.assertEquals((Object)createParent, (Object)options.getCreateParent());
        Assert.assertEquals((Object)owner, (Object)options.getOwner());
        Assert.assertEquals((Object)group, (Object)options.getGroup());
        Assert.assertEquals((Object)mode, (Object)options.getMode());
    }

    @Test
    public void equalsTest() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{MkdirsOptions.defaults((AlluxioConfiguration)this.mConfiguration), MkdirsOptions.defaults((AlluxioConfiguration)this.mConfiguration)}).testEquals();
    }
}

