/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authentication.AuthType;
import alluxio.security.authorization.Mode;
import alluxio.security.group.provider.IdentityUserGroupsMapping;
import alluxio.underfs.options.CreateOptions;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ModeUtils;
import com.google.common.testing.EqualsTester;
import java.io.IOException;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class CreateOptionsTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    @Test
    public void defaults() throws IOException {
        CreateOptions options = CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        Assert.assertFalse((boolean)options.getCreateParent());
        Assert.assertFalse((boolean)options.isEnsureAtomic());
        Assert.assertNull((Object)options.getOwner());
        Assert.assertNull((Object)options.getGroup());
        String umask = this.mConfiguration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK);
        Assert.assertEquals((Object)ModeUtils.applyFileUMask((Mode)Mode.defaults(), (String)umask), (Object)options.getMode());
    }

    @Test
    public void securityEnabled() throws IOException {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"foo");
        this.mConfiguration.set(PropertyKey.SECURITY_GROUP_MAPPING_CLASS, (Object)IdentityUserGroupsMapping.class.getName());
        CreateOptions options = CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        Assert.assertFalse((boolean)options.getCreateParent());
        Assert.assertFalse((boolean)options.isEnsureAtomic());
        Assert.assertNull((Object)options.getOwner());
        Assert.assertNull((Object)options.getGroup());
        String umask = this.mConfiguration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK);
        Assert.assertEquals((Object)ModeUtils.applyFileUMask((Mode)Mode.defaults(), (String)umask), (Object)options.getMode());
    }

    @Test
    public void fields() {
        Random random = new Random();
        boolean createParent = random.nextBoolean();
        boolean ensureAtomic = random.nextBoolean();
        String owner = CommonUtils.randomAlphaNumString((int)10);
        String group = CommonUtils.randomAlphaNumString((int)10);
        Mode mode = new Mode((short)random.nextInt());
        CreateOptions options = CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration);
        options.setCreateParent(createParent);
        options.setEnsureAtomic(ensureAtomic);
        options.setOwner(owner);
        options.setGroup(group);
        options.setMode(mode);
        Assert.assertEquals((Object)createParent, (Object)options.getCreateParent());
        Assert.assertEquals((Object)ensureAtomic, (Object)options.isEnsureAtomic());
        Assert.assertEquals((Object)owner, (Object)options.getOwner());
        Assert.assertEquals((Object)group, (Object)options.getGroup());
        Assert.assertEquals((Object)mode, (Object)options.getMode());
    }

    @Test
    public void equalsTest() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration), CreateOptions.defaults((AlluxioConfiguration)this.mConfiguration)}).testEquals();
    }
}

