/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public final class UnderFileSystemTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void coreFactory() {
        UnderFileSystemFactory factory = UnderFileSystemFactoryRegistry.find((String)"/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"An UnderFileSystemFactory should not exist for local file paths", (Object)factory);
        factory = UnderFileSystemFactoryRegistry.find((String)"file:///test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"An UnderFileSystemFactory should not exist for local file paths", (Object)factory);
    }

    @Test
    public void externalFactory() {
        Assume.assumeTrue((UnderFileSystemFactoryRegistry.available().size() == 1 ? 1 : 0) != 0);
        UnderFileSystemFactory factory = UnderFileSystemFactoryRegistry.find((String)"hdfs://localhost/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"No UnderFileSystemFactory should exist for HDFS paths as it requires a separate module", (Object)factory);
        factory = UnderFileSystemFactoryRegistry.find((String)"oss://localhost/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"No UnderFileSystemFactory should exist for OSS paths as it requires a separate module", (Object)factory);
        factory = UnderFileSystemFactoryRegistry.find((String)"s3://localhost/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"No UnderFileSystemFactory should exist for S3 paths as it requires a separate module", (Object)factory);
        factory = UnderFileSystemFactoryRegistry.find((String)"s3a://localhost/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"No UnderFileSystemFactory should exist for S3 paths as it requires a separate module", (Object)factory);
        factory = UnderFileSystemFactoryRegistry.find((String)"glusterfs://localhost/test/path", (AlluxioConfiguration)this.mConfiguration);
        Assert.assertNull((String)"No UnderFileSystemFactory should exist for Gluster FS paths as it requires a separate module", (Object)factory);
    }
}

