/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.ConfigurationRule;
import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystemConfiguration;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class UnderFileSystemConfigurationTest {
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void getValueWhenGlobalConfHasProperty() throws Exception {
        try (Closeable c = new ConfigurationRule(PropertyKey.S3A_ACCESS_KEY, "bar", this.mConfiguration).toResource();){
            Random random = new Random();
            boolean readOnly = random.nextBoolean();
            boolean shared = random.nextBoolean();
            UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ConfigurationTestUtils.defaults()).setReadOnly(readOnly).setShared(shared);
            Assert.assertEquals((Object)readOnly, (Object)conf.isReadOnly());
            Assert.assertEquals((Object)shared, (Object)conf.isShared());
            Assert.assertEquals((Object)"bar", (Object)this.mConfiguration.get(PropertyKey.S3A_ACCESS_KEY));
            conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)ConfigurationTestUtils.defaults()).setReadOnly(readOnly).setShared(shared).createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_ACCESS_KEY.toString(), (Object)"foo"));
            Assert.assertEquals((Object)readOnly, (Object)conf.isReadOnly());
            Assert.assertEquals((Object)shared, (Object)conf.isShared());
            Assert.assertEquals((Object)"foo", (Object)conf.get(PropertyKey.S3A_ACCESS_KEY));
        }
    }

    @Test
    public void getValueWhenGlobalConfOverridesPropertyWithDefaultValue() throws Exception {
        try (Closeable c = new ConfigurationRule(PropertyKey.UNDERFS_LISTING_LENGTH, "2000", this.mConfiguration).toResource();){
            UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConfiguration);
            Assert.assertEquals((Object)"2000", (Object)conf.get(PropertyKey.UNDERFS_LISTING_LENGTH));
        }
    }

    @Test
    public void getValueWhenGlobalConfHasNotProperty() throws Exception {
        try (Closeable c = new ConfigurationRule(PropertyKey.S3A_ACCESS_KEY, null, this.mConfiguration).toResource();){
            Random random = new Random();
            boolean readOnly = random.nextBoolean();
            boolean shared = random.nextBoolean();
            UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConfiguration).setReadOnly(readOnly).setShared(shared);
            try {
                conf.get(PropertyKey.S3A_ACCESS_KEY);
                Assert.fail((String)"this key should not exist");
            }
            catch (Exception exception) {
                // empty catch block
            }
            UnderFileSystemConfiguration conf2 = conf.createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_ACCESS_KEY.toString(), (Object)"foo"));
            Assert.assertEquals((Object)readOnly, (Object)conf2.isReadOnly());
            Assert.assertEquals((Object)shared, (Object)conf2.isShared());
            Assert.assertEquals((Object)"foo", (Object)conf2.get(PropertyKey.S3A_ACCESS_KEY));
        }
    }

    @Test
    public void containsWhenGlobalConfHasProperty() throws Exception {
        try (Closeable c = new ConfigurationRule(PropertyKey.S3A_ACCESS_KEY, "bar", this.mConfiguration).toResource();){
            Random random = new Random();
            boolean readOnly = random.nextBoolean();
            boolean shared = random.nextBoolean();
            UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConfiguration).setReadOnly(readOnly).setShared(shared);
            Assert.assertTrue((boolean)conf.isSet(PropertyKey.S3A_ACCESS_KEY));
            conf.createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_ACCESS_KEY.toString(), (Object)"foo"));
            Assert.assertEquals((Object)readOnly, (Object)conf.isReadOnly());
            Assert.assertEquals((Object)shared, (Object)conf.isShared());
            Assert.assertTrue((boolean)conf.isSet(PropertyKey.S3A_ACCESS_KEY));
        }
    }

    @Test
    public void containsWhenGlobalConfHasNotProperty() throws Exception {
        try (Closeable c = new ConfigurationRule(PropertyKey.S3A_ACCESS_KEY, null, this.mConfiguration).toResource();){
            Random random = new Random();
            boolean readOnly = random.nextBoolean();
            boolean shared = random.nextBoolean();
            UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConfiguration).setReadOnly(readOnly).setShared(shared);
            Assert.assertFalse((boolean)conf.isSet(PropertyKey.S3A_ACCESS_KEY));
            UnderFileSystemConfiguration conf2 = conf.createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_ACCESS_KEY.toString(), (Object)"foo"));
            Assert.assertEquals((Object)readOnly, (Object)conf2.isReadOnly());
            Assert.assertEquals((Object)shared, (Object)conf2.isShared());
            Assert.assertTrue((boolean)conf2.isSet(PropertyKey.S3A_ACCESS_KEY));
        }
    }

    @Test
    public void setUserSpecifiedConfRepeatedly() throws Exception {
        UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConfiguration);
        UnderFileSystemConfiguration conf2 = conf.createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_ACCESS_KEY.toString(), (Object)"foo"));
        Assert.assertEquals((Object)"foo", (Object)conf2.get(PropertyKey.S3A_ACCESS_KEY));
        Assert.assertEquals((long)1L, (long)conf2.getMountSpecificConf().size());
        conf2 = conf.createMountSpecificConf((Map)ImmutableMap.of((Object)PropertyKey.S3A_SECRET_KEY.toString(), (Object)"bar"));
        Assert.assertEquals((Object)"bar", (Object)conf2.get(PropertyKey.S3A_SECRET_KEY));
        Assert.assertFalse((boolean)conf2.isSet(PropertyKey.S3A_ACCESS_KEY));
        Assert.assertEquals((long)1L, (long)conf2.getMountSpecificConf().size());
        Assert.assertEquals((long)0L, (long)conf.getMountSpecificConf().size());
    }
}

