/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.underfs.UfsFileStatus;
import alluxio.util.CommonUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class UfsFileStatusTest {
    @Test
    public void fields() {
        Random random = new Random();
        String contentHash = CommonUtils.randomAlphaNumString((int)10);
        long contentLength = random.nextLong();
        long lastModifiedTimeMs = random.nextLong();
        short mode = 63;
        long blockSize = random.nextLong();
        UfsFileStatus status = new UfsFileStatus("name", contentHash, contentLength, lastModifiedTimeMs, "owner", "group", mode, blockSize);
        Assert.assertEquals((Object)"name", (Object)status.getName());
        Assert.assertEquals((Object)contentHash, (Object)status.getContentHash());
        Assert.assertEquals((long)contentLength, (long)status.getContentLength());
        Assert.assertEquals((Object)false, (Object)status.isDirectory());
        Assert.assertEquals((Object)true, (Object)status.isFile());
        Assert.assertEquals((long)lastModifiedTimeMs, (long)status.getLastModifiedTime());
        Assert.assertEquals((Object)"owner", (Object)status.getOwner());
        Assert.assertEquals((Object)"group", (Object)status.getGroup());
        Assert.assertEquals((long)mode, (long)status.getMode());
        Assert.assertEquals((long)blockSize, (long)status.getBlockSize());
    }

    @Test
    public void copy() {
        Random random = new Random();
        String contentHash = CommonUtils.randomAlphaNumString((int)10);
        long contentLength = random.nextLong();
        long lastModifiedTimeMs = random.nextLong();
        short mode = 63;
        long blockSize = random.nextLong();
        UfsFileStatus statusToCopy = new UfsFileStatus("name", contentHash, contentLength, lastModifiedTimeMs, "owner", "group", mode, blockSize);
        UfsFileStatus status = new UfsFileStatus(statusToCopy);
        Assert.assertEquals((Object)statusToCopy, (Object)status);
    }
}

