/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.security.authorization.AccessControlList;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.util.CommonUtils;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class FingerprintTest {
    private Random mRandom = new Random();

    @Test
    public void parseFileFingerprint() {
        UfsFileStatus status = new UfsFileStatus(CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), this.mRandom.nextLong(), this.mRandom.nextLong(), CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), (short)this.mRandom.nextInt(), this.mRandom.nextLong());
        Fingerprint fp = Fingerprint.create((String)CommonUtils.randomAlphaNumString((int)10), (UfsStatus)status);
        String expected = fp.serialize();
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Object)expected, (Object)Fingerprint.parse((String)expected).serialize());
    }

    @Test
    public void parseDirectoryFingerprint() {
        UfsDirectoryStatus status = new UfsDirectoryStatus(CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), (short)this.mRandom.nextInt(), Long.valueOf(this.mRandom.nextLong()));
        Fingerprint fp = Fingerprint.create((String)CommonUtils.randomAlphaNumString((int)10), (UfsStatus)status);
        String expected = fp.serialize();
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Object)expected, (Object)Fingerprint.parse((String)expected).serialize());
    }

    @Test
    public void parseInvalidFingerprint() {
        Fingerprint fp = Fingerprint.create((String)CommonUtils.randomAlphaNumString((int)10), null);
        String expected = fp.serialize();
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Object)expected, (Object)Fingerprint.parse((String)expected).serialize());
    }

    @Test
    public void matchMetadataOrContent() {
        String name = CommonUtils.randomAlphaNumString((int)10);
        String contentHash = CommonUtils.randomAlphaNumString((int)10);
        String contentHash2 = CommonUtils.randomAlphaNumString((int)11);
        Long contentLength = this.mRandom.nextLong();
        Long lastModifiedTimeMs = this.mRandom.nextLong();
        String owner = CommonUtils.randomAlphaNumString((int)10);
        String group = CommonUtils.randomAlphaNumString((int)10);
        short mode = (short)this.mRandom.nextInt();
        String ufsName = CommonUtils.randomAlphaNumString((int)10);
        Long blockSize = this.mRandom.nextLong();
        UfsFileStatus status = new UfsFileStatus(name, contentHash, contentLength.longValue(), lastModifiedTimeMs.longValue(), owner, group, mode, blockSize.longValue());
        UfsFileStatus metadataChangedStatus = new UfsFileStatus(name, contentHash, contentLength.longValue(), lastModifiedTimeMs.longValue(), CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), mode, blockSize.longValue());
        UfsFileStatus dataChangedStatus = new UfsFileStatus(name, contentHash2, contentLength.longValue(), lastModifiedTimeMs.longValue(), owner, group, mode, blockSize.longValue());
        Fingerprint fp = Fingerprint.create((String)ufsName, (UfsStatus)status);
        Fingerprint fpMetadataChanged = Fingerprint.create((String)ufsName, (UfsStatus)metadataChangedStatus);
        Fingerprint fpDataChanged = Fingerprint.create((String)ufsName, (UfsStatus)dataChangedStatus);
        Assert.assertTrue((boolean)fp.matchMetadata(fp));
        Assert.assertFalse((boolean)fp.matchMetadata(fpMetadataChanged));
        Assert.assertTrue((boolean)fp.matchContent(fpMetadataChanged));
        Assert.assertFalse((boolean)fp.matchContent(fpDataChanged));
        Assert.assertTrue((boolean)fp.matchMetadata(fpDataChanged));
    }

    @Test
    public void createFingerprintFromUfsStatus() {
        String name = CommonUtils.randomAlphaNumString((int)10);
        String owner = CommonUtils.randomAlphaNumString((int)10);
        String group = CommonUtils.randomAlphaNumString((int)10);
        short mode = (short)this.mRandom.nextInt();
        String ufsName = CommonUtils.randomAlphaNumString((int)10);
        UfsDirectoryStatus dirStatus = new UfsDirectoryStatus(name, owner, group, mode);
        Fingerprint fp = Fingerprint.create((String)ufsName, (UfsStatus)dirStatus);
        Assert.assertEquals((Object)owner, (Object)fp.getTag(Fingerprint.Tag.OWNER));
        Assert.assertEquals((Object)group, (Object)fp.getTag(Fingerprint.Tag.GROUP));
        Assert.assertEquals((Object)String.valueOf(mode), (Object)fp.getTag(Fingerprint.Tag.MODE));
        String contentHash = CommonUtils.randomAlphaNumString((int)10);
        Long contentLength = this.mRandom.nextLong();
        Long lastModifiedTimeMs = this.mRandom.nextLong();
        Long blockSize = this.mRandom.nextLong();
        UfsFileStatus fileStatus = new UfsFileStatus(name, contentHash, contentLength.longValue(), lastModifiedTimeMs.longValue(), owner, group, mode, blockSize.longValue());
        fp = Fingerprint.create((String)ufsName, (UfsStatus)fileStatus);
        Assert.assertEquals((Object)owner, (Object)fp.getTag(Fingerprint.Tag.OWNER));
        Assert.assertEquals((Object)group, (Object)fp.getTag(Fingerprint.Tag.GROUP));
        Assert.assertEquals((Object)String.valueOf(mode), (Object)fp.getTag(Fingerprint.Tag.MODE));
    }

    @Test
    public void createACLFingeprint() {
        UfsFileStatus status = new UfsFileStatus(CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), this.mRandom.nextLong(), this.mRandom.nextLong(), CommonUtils.randomAlphaNumString((int)10), CommonUtils.randomAlphaNumString((int)10), (short)this.mRandom.nextInt(), this.mRandom.nextLong());
        AccessControlList acl = AccessControlList.fromStringEntries((String)CommonUtils.randomAlphaNumString((int)10), (String)CommonUtils.randomAlphaNumString((int)10), Arrays.asList("user::rw-", "group::r--", "other::rwx"));
        Fingerprint fp = Fingerprint.create((String)CommonUtils.randomAlphaNumString((int)10), (UfsStatus)status, (AccessControlList)acl);
        String expected = fp.serialize();
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Object)"user::rw-,group::r--,other::rwx", (Object)Fingerprint.parse((String)expected).getTag(Fingerprint.Tag.ACL));
        Assert.assertEquals((Object)expected, (Object)Fingerprint.parse((String)expected).serialize());
    }
}

