/*
 * Decompiled with CFR 0.152.
 */
package alluxio.time;

import alluxio.time.ManualSleeper;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ManualSleeperTest {
    private AtomicInteger mSleepTime;
    private ManualSleeper mSleeper;
    private Thread mTestThread;

    @Before
    public void before() {
        this.mSleepTime = new AtomicInteger(0);
        this.mSleeper = new ManualSleeper();
        this.mTestThread = new Thread(() -> {
            try {
                while (true) {
                    this.mSleeper.sleep(Duration.ofMillis(this.mSleepTime.incrementAndGet()));
                }
            }
            catch (InterruptedException e) {
                return;
            }
        });
        this.mTestThread.setDaemon(true);
        this.mTestThread.start();
    }

    @After
    public void after() throws InterruptedException {
        this.mTestThread.interrupt();
        this.mTestThread.join(1000L);
    }

    @Test
    public void checkSleepTime() throws InterruptedException {
        for (int i = 1; i < 100; ++i) {
            Assert.assertEquals((long)i, (long)this.mSleeper.waitForSleep().toMillis());
            this.mSleeper.wakeUp();
        }
    }

    @Test
    public void propagateInterrupt() throws InterruptedException {
        this.mTestThread.interrupt();
        this.mTestThread.join(1000L);
        Assert.assertFalse((boolean)this.mTestThread.isAlive());
    }
}

