/*
 * Decompiled with CFR 0.152.
 */
package alluxio.time;

import alluxio.time.Sleeper;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ManualSleeper
implements Sleeper {
    private final Lock mSleepLock = new ReentrantLock();
    private final Condition mSleepLockCond = this.mSleepLock.newCondition();
    private Duration mLastSleep = Duration.ZERO;
    private boolean mSleeping = false;

    public void sleep(Duration duration) throws InterruptedException {
        this.mSleepLock.lock();
        this.mLastSleep = duration;
        this.mSleeping = true;
        this.mSleepLockCond.signalAll();
        try {
            while (this.mSleeping) {
                this.mSleepLockCond.await();
            }
        }
        finally {
            this.mSleeping = false;
            this.mSleepLock.unlock();
        }
    }

    public boolean sleeping() {
        this.mSleepLock.lock();
        try {
            boolean bl = this.mSleeping;
            return bl;
        }
        finally {
            this.mSleepLock.unlock();
        }
    }

    public Duration waitForSleep() throws InterruptedException {
        this.mSleepLock.lock();
        try {
            while (!this.mSleeping) {
                this.mSleepLockCond.await();
            }
            Duration duration = this.mLastSleep;
            return duration;
        }
        finally {
            this.mSleepLock.unlock();
        }
    }

    public void wakeUp() {
        this.mSleepLock.lock();
        Preconditions.checkState((boolean)this.mSleeping, (Object)"Called wakeUp when nothing was sleeping");
        try {
            this.mSleeping = false;
            this.mSleepLockCond.signal();
        }
        finally {
            this.mSleepLock.unlock();
        }
    }
}

