/*
 * Decompiled with CFR 0.152.
 */
package alluxio.time;

import alluxio.time.ExponentialTimer;
import alluxio.util.CommonUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialTimerTest {
    @Test
    public void expiration() {
        int maxTotalWaitTimeMs = 1000;
        ExponentialTimer timer = new ExponentialTimer(0L, 0L, 0L, (long)maxTotalWaitTimeMs);
        Assert.assertEquals((Object)ExponentialTimer.Result.READY, (Object)timer.tick());
        CommonUtils.sleepMs((long)maxTotalWaitTimeMs);
        Assert.assertEquals((Object)ExponentialTimer.Result.EXPIRED, (Object)timer.tick());
    }

    @Test(timeout=2000L)
    public void backoff() {
        int n = 10;
        ExponentialTimer timer = new ExponentialTimer(1L, 1000L, 0L, 1000L);
        long start = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            while (timer.tick() == ExponentialTimer.Result.NOT_READY) {
                CommonUtils.sleepMs((long)10L);
            }
            long now = System.currentTimeMillis();
            Assert.assertTrue((now - start >= (long)(1 << i - 1) ? 1 : 0) != 0);
        }
    }
}

