/*
 * Decompiled with CFR 0.152.
 */
package alluxio.test.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public final class ConcurrencyUtils {
    private ConcurrencyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertConcurrent(List<? extends Runnable> runnables, int maxTimeoutSeconds) throws InterruptedException {
        int numThreads = runnables.size();
        List exceptions = Collections.synchronizedList(new ArrayList());
        ExecutorService threadPool = Executors.newFixedThreadPool(numThreads);
        try {
            CountDownLatch allExecutorThreadsReady = new CountDownLatch(numThreads);
            CountDownLatch afterInitBlocker = new CountDownLatch(1);
            CountDownLatch allDone = new CountDownLatch(numThreads);
            for (Runnable runnable : runnables) {
                threadPool.submit(() -> {
                    allExecutorThreadsReady.countDown();
                    try {
                        afterInitBlocker.await();
                        submittedTestRunnable.run();
                    }
                    catch (Throwable e) {
                        exceptions.add(e);
                    }
                    finally {
                        allDone.countDown();
                    }
                });
            }
            Assert.assertTrue((String)"Timeout initializing threads!", (boolean)allExecutorThreadsReady.await(runnables.size() * 10, TimeUnit.MILLISECONDS));
            afterInitBlocker.countDown();
            Assert.assertTrue((String)("Timeout! More than " + maxTimeoutSeconds + " seconds"), (boolean)allDone.await(maxTimeoutSeconds, TimeUnit.SECONDS));
        }
        finally {
            threadPool.shutdownNow();
        }
        Assert.assertTrue((String)("Failed with exception(s) " + exceptions), (boolean)exceptions.isEmpty());
    }
}

