/*
 * Decompiled with CFR 0.152.
 */
package alluxio.test.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.reflect.Whitebox;

public final class CommonUtils {
    private static final Map<Class<?>, List<?>> PRIMITIVE_VALUES = ImmutableMap.builder().put(Boolean.TYPE, (Object)Lists.newArrayList((Object[])new Boolean[]{true, false})).put(Character.TYPE, (Object)Lists.newArrayList((Object[])new Character[]{Character.valueOf('a'), Character.valueOf('b')})).put(Byte.TYPE, (Object)Lists.newArrayList((Object[])new Byte[]{(byte)10, (byte)11})).put(Short.TYPE, (Object)Lists.newArrayList((Object[])new Short[]{(short)20, (short)21})).put(Integer.TYPE, (Object)Lists.newArrayList((Object[])new Integer[]{30, 31})).put(Long.TYPE, (Object)Lists.newArrayList((Object[])new Long[]{40L, 41L})).put(Float.TYPE, (Object)Lists.newArrayList((Object[])new Float[]{Float.valueOf(50.0f), Float.valueOf(51.0f)})).put(Double.TYPE, (Object)Lists.newArrayList((Object[])new Double[]{60.0, 61.0})).build();

    public static <T> T getInternalState(Object instance, String ... fieldNames) {
        Object current = instance;
        for (String fieldName : fieldNames) {
            Object next = Whitebox.getInternalState((Object)current, (String)fieldName);
            if (next == null) {
                throw new RuntimeException("Couldn't find field " + fieldName + " in " + current.getClass());
            }
            current = next;
        }
        Object finalObject = current;
        return (T)finalObject;
    }

    public static <T> void testEquals(Class<T> clazz, String ... excludedFields) {
        CommonUtils.testEquals(clazz, null, null, excludedFields);
    }

    public static <T> void testEquals(Class<T> clazz, Class<?>[] ctorClassArgs, Object[] ctorArgs, String ... excludedFields) {
        HashSet<String> excludedFieldsSet = new HashSet<String>(Arrays.asList(excludedFields));
        EqualsTester equalsTester = new EqualsTester();
        equalsTester.addEqualityGroup(new Object[]{CommonUtils.createBaseObject(clazz, ctorClassArgs, ctorArgs), CommonUtils.createBaseObject(clazz, ctorClassArgs, ctorArgs)});
        for (Field field : CommonUtils.getNonStaticFields(clazz)) {
            if (excludedFieldsSet.contains(field.getName())) continue;
            field.setAccessible(true);
            T instance = CommonUtils.createBaseObject(clazz, ctorClassArgs, ctorArgs);
            try {
                field.set(instance, CommonUtils.getValuesForFieldType(field.getType()).get(1));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            equalsTester.addEqualityGroup(new Object[]{instance});
        }
        equalsTester.testEquals();
    }

    private static <T> T createBaseObject(Class<T> clazz, Class<?>[] ctorClassArgs, Object[] ctorArgs) {
        try {
            Constructor<T> ctor = ctorClassArgs == null || ctorClassArgs.length == 0 ? clazz.getDeclaredConstructor(new Class[0]) : clazz.getConstructor(ctorClassArgs);
            ctor.setAccessible(true);
            T instance = ctorClassArgs == null || ctorClassArgs.length == 0 ? ctor.newInstance(new Object[0]) : ctor.newInstance(ctorArgs);
            for (Field field : CommonUtils.getNonStaticFields(clazz)) {
                field.setAccessible(true);
                field.set(instance, CommonUtils.getValuesForFieldType(field.getType()).get(0));
            }
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<?> getValuesForFieldType(Class<?> type) throws Exception {
        if (type.isEnum()) {
            ArrayList enumValues = Lists.newArrayList((Object[])type.getEnumConstants());
            enumValues.add(null);
            return enumValues;
        }
        List<?> primitiveValues = PRIMITIVE_VALUES.get(type);
        if (primitiveValues != null) {
            return primitiveValues;
        }
        ArrayList classValues = Lists.newArrayList();
        classValues.add(null);
        try {
            classValues.add(PowerMockito.mock(type));
        }
        catch (Exception e) {
            try {
                Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                classValues.add(constructor.newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e1) {
                throw new RuntimeException("Couldn't create an instance of " + type.getName() + ". Please use @PrepareForTest.");
            }
        }
        return classValues;
    }

    private static List<Field> getNonStaticFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static void classLoadURL(String path) throws Exception {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, new File(path).toURI().toURL());
        }
        catch (NoSuchMethodException e) {
            Method method = classLoader.getClass().getDeclaredMethod("appendToClassPathForInstrumentation", String.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, path);
        }
    }
}

