/*
 * Decompiled with CFR 0.152.
 */
package alluxio.test.util;

import alluxio.test.util.CommonUtils;
import alluxio.underfs.UnderFileSystem;
import java.util.Objects;
import junit.framework.AssertionFailedError;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={HardToInstantiateClass.class})
public final class CommonTestUtilsTest {
    @Test
    public void testEqualsBasic() throws Exception {
        CommonUtils.testEquals(Basic.class, new String[0]);
    }

    @Test
    public void testEqualsManyFields() {
        CommonUtils.testEquals(ManyFields.class, new String[0]);
    }

    @Test
    public void testEqualsBadHashCodeCheck() {
        this.testFail(BadHashCode.class);
    }

    @Test
    public void testEqualsMissingFieldCheck() {
        this.testFail(MissingField.class);
    }

    @Test
    public void testEqualsMissingInstanceCheck() {
        this.testFail(EqualsMissingInstanceCheck.class);
    }

    private void testFail(Class<?> clazz) {
        try {
            CommonUtils.testEquals(clazz, new String[0]);
            Assert.fail((String)("testEquals didn't throw an error for class " + clazz.getName()));
        }
        catch (NullPointerException | AssertionFailedError throwable) {
            // empty catch block
        }
    }

    private static class EqualsMissingInstanceCheck {
        private String mField1;
        private boolean mField2;
        private CommonUtils mField3;

        private EqualsMissingInstanceCheck() {
        }

        public boolean equals(Object o) {
            MissingField that = (MissingField)o;
            return Objects.equals(this.mField1, that.mField1) && Objects.equals(this.mField2, that.mField2) && Objects.equals(this.mField3, that.mField3);
        }

        public int hashCode() {
            return Objects.hash(this.mField1, this.mField2, this.mField3);
        }
    }

    private static class MissingField {
        private String mField1;
        private boolean mField2;
        private CommonUtils mField3;

        private MissingField() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof MissingField)) {
                return false;
            }
            MissingField that = (MissingField)o;
            return Objects.equals(this.mField1, that.mField1) && Objects.equals(this.mField2, that.mField2);
        }

        public int hashCode() {
            return Objects.hash(this.mField1, this.mField2);
        }
    }

    private static class ManyFields {
        private String mField1;
        private boolean mField2;
        private HardToInstantiateClass mField3;
        private UnderFileSystem.SpaceType mField4;

        private ManyFields() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof ManyFields)) {
                return false;
            }
            ManyFields that = (ManyFields)o;
            return Objects.equals(this.mField1, that.mField1) && Objects.equals(this.mField2, that.mField2) && Objects.equals(this.mField3, that.mField3) && Objects.equals(this.mField4, that.mField4);
        }

        public int hashCode() {
            return Objects.hash(this.mField1, this.mField2, this.mField3, this.mField4);
        }
    }

    private static class BadHashCode {
        private String mField;

        private BadHashCode() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof Basic)) {
                return false;
            }
            Basic that = (Basic)o;
            return Objects.equals(this.mField, that.mField);
        }

        public int hashCode() {
            return Objects.hash(10);
        }
    }

    private static class Basic {
        private String mField;

        private Basic() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Basic)) {
                return false;
            }
            Basic that = (Basic)o;
            return Objects.equals(this.mField, that.mField);
        }

        public int hashCode() {
            return Objects.hash(this.mField);
        }
    }

    public static final class HardToInstantiateClass {
        private HardToInstantiateClass(Object o) {
        }
    }
}

