/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shell;

import alluxio.AlluxioTestDirectory;
import alluxio.shell.CommandReturn;
import alluxio.shell.ShellCommand;
import alluxio.util.ShellUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ShellCommandTest {
    @Rule
    public ExpectedException mExceptionRule = ExpectedException.none();

    public static File createFileInDir(File dir, String fileName) throws IOException {
        File newFile = new File(Paths.get(dir.getAbsolutePath(), fileName).toString());
        newFile.createNewFile();
        return newFile;
    }

    @Test
    public void execCommand() throws Exception {
        String testString = "alluxio";
        String[] cmd = new String[]{"bash", "-c", "echo " + testString};
        String result = new ShellCommand(cmd).run();
        Assert.assertEquals((Object)(testString + "\n"), (Object)result);
    }

    @Test
    public void execCommandFail() throws Exception {
        this.mExceptionRule.expect(ShellUtils.ExitCodeException.class);
        String[] cmd = new String[]{"bash", "-c", "false"};
        String result = new ShellCommand(cmd).run();
        Assert.assertEquals((Object)"false\n", (Object)result);
    }

    @Test
    public void execCommandTolerateFailureSucceed() throws Exception {
        File testDir = AlluxioTestDirectory.createTemporaryDirectory("command");
        File testFile = ShellCommandTest.createFileInDir(testDir, "testFile");
        String[] testCommandSucceed = new String[]{"ls", String.format("%s", testDir.getAbsolutePath())};
        CommandReturn crs = new ShellCommand(testCommandSucceed).runWithOutput();
        Assert.assertEquals((long)0L, (long)crs.getExitCode());
        Assert.assertTrue((boolean)crs.getOutput().contains(testFile.getName()));
    }

    @Test
    public void execCommandTolerateFailureFailed() throws Exception {
        File testDir = AlluxioTestDirectory.createTemporaryDirectory("command");
        String[] testCommandFail = new String[]{"ls", String.format("%saaaa", testDir.getAbsolutePath())};
        CommandReturn crf = new ShellCommand(testCommandFail).runWithOutput();
        Assert.assertNotEquals((long)0L, (long)crf.getExitCode());
        Assert.assertTrue((crf.getOutput().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"", (Object)crf.getOutput());
    }

    @Test
    public void execCommandTolerateFailureInvalidCommand() throws Exception {
        File testDir = AlluxioTestDirectory.createTemporaryDirectory("command");
        String[] testCommandExcept = new String[]{"lsa", String.format("%s", testDir.getAbsolutePath())};
        CommandReturn crf = new ShellCommand(testCommandExcept).runWithOutput();
        System.out.println(crf.getFormattedOutput());
        Assert.assertNotEquals((long)0L, (long)crf.getExitCode());
        Assert.assertTrue((boolean)crf.getOutput().contains("No such file or directory"));
    }
}

