/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.user;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.User;
import alluxio.security.authentication.AuthType;
import alluxio.security.user.UserState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public final class UserStateTest {
    private InstancedConfiguration mConfiguration = ConfigurationTestUtils.defaults();

    @After
    public void after() {
        this.mConfiguration = ConfigurationTestUtils.defaults();
    }

    @Test
    public void getSimpleLoginUser() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)loginUser.getName());
    }

    @Test
    public void getSimpleLoginUserProvidedByApp() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"alluxio-user");
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)"alluxio-user", (Object)loginUser.getName());
    }

    @Test
    public void getSimpleLoginUserListProvidedByApp() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"alluxio-user, superuser");
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)"alluxio-user, superuser", (Object)loginUser.getName());
    }

    @Test
    public void getSimpleLoginUserWhenNotProvidedByApp() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.SIMPLE.getAuthName());
        this.mConfiguration.unset(PropertyKey.SECURITY_LOGIN_USERNAME);
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)loginUser.getName());
    }

    @Test
    public void getCustomLoginUser() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.CUSTOM.getAuthName());
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)loginUser.getName());
    }

    @Test
    public void getCustomLoginUserProvidedByApp() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.CUSTOM.getAuthName());
        this.mConfiguration.set(PropertyKey.SECURITY_LOGIN_USERNAME, (Object)"alluxio-user");
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)"alluxio-user", (Object)loginUser.getName());
    }

    @Test
    public void getCustomLoginUserWhenNotProvidedByApp() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.CUSTOM.getAuthName());
        this.mConfiguration.unset(PropertyKey.SECURITY_LOGIN_USERNAME);
        UserState s = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration);
        User loginUser = s.getUser();
        Assert.assertNotNull((Object)loginUser);
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)loginUser.getName());
    }

    @Test
    public void securityEnabled() throws Exception {
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHENTICATION_TYPE, (Object)AuthType.NOSASL.getAuthName());
        User u = UserState.Factory.create((AlluxioConfiguration)this.mConfiguration).getUser();
        Assert.assertEquals((Object)"", (Object)u.getName());
    }
}

