/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.security.User;
import alluxio.security.login.LoginModuleConfiguration;
import alluxio.security.login.LoginModuleConfigurationUtils;
import alluxio.util.CommonUtils;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class LoginModuleTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void simpleLogin() throws Exception {
        String clazzName = LoginModuleConfigurationUtils.OS_PRINCIPAL_CLASS_NAME;
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(clazzName);
        Subject subject = new Subject();
        LoginContext loginContext = new LoginContext("simple", subject, null, (Configuration)new LoginModuleConfiguration());
        loginContext.login();
        Assert.assertFalse((boolean)subject.getPrincipals(clazz).isEmpty());
        Assert.assertFalse((boolean)subject.getPrincipals(User.class).isEmpty());
        loginContext.logout();
        Assert.assertTrue((boolean)subject.getPrincipals(User.class).isEmpty());
        if (CommonUtils.getJavaVersion() == 8) {
            loginContext.logout();
            Assert.assertTrue((boolean)subject.getPrincipals(User.class).isEmpty());
        }
    }

    @Test
    public void logoutReadOnlySubject() throws Exception {
        String clazzName = LoginModuleConfigurationUtils.OS_PRINCIPAL_CLASS_NAME;
        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(clazzName);
        Subject subject = new Subject();
        LoginContext loginContext = new LoginContext("simple", subject, null, (Configuration)new LoginModuleConfiguration());
        loginContext.login();
        Assert.assertFalse((boolean)subject.getPrincipals(clazz).isEmpty());
        Assert.assertFalse((boolean)subject.getPrincipals(User.class).isEmpty());
        subject.setReadOnly();
        this.mThrown.expect(LoginException.class);
        this.mThrown.expectMessage("logout Failed: Subject is Readonly");
        loginContext.logout();
        Assert.assertFalse((boolean)subject.getPrincipals(clazz).isEmpty());
        Assert.assertFalse((boolean)subject.getPrincipals(User.class).isEmpty());
    }
}

