/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.group;

import alluxio.security.group.provider.ShellBasedUnixGroupsMapping;
import alluxio.util.CommonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={CommonUtils.class})
public final class ShellBasedUnixGroupsMappingTest {
    private void setupShellMocks(String username, List<String> groups) throws IOException {
        PowerMockito.mockStatic(CommonUtils.class, (Class[])new Class[0]);
        PowerMockito.when((Object)CommonUtils.getUnixGroups((String)((String)Mockito.eq((Object)username)))).thenReturn(groups);
    }

    @Test
    public void userGroup() throws Throwable {
        String userName = "alluxio-user1";
        String userGroup1 = "alluxio-user1-group1";
        String userGroup2 = "alluxio-user1-group2";
        ArrayList<String> userGroups = new ArrayList<String>();
        userGroups.add(userGroup1);
        userGroups.add(userGroup2);
        this.setupShellMocks(userName, userGroups);
        ShellBasedUnixGroupsMapping groups = new ShellBasedUnixGroupsMapping();
        Assert.assertNotNull((Object)groups);
        Assert.assertNotNull((Object)groups.getGroups(userName));
        Assert.assertEquals((long)groups.getGroups(userName).size(), (long)2L);
    }
}

