/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.ExceptionMessage;
import alluxio.security.authorization.Mode;
import alluxio.util.ConfigurationUtils;
import alluxio.util.ModeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class ModeTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();
    private InstancedConfiguration mConfiguration;

    @Before
    public void before() {
        this.mConfiguration = new InstancedConfiguration(ConfigurationUtils.defaults());
    }

    @Test
    public void defaults() {
        Mode mode = Mode.defaults();
        Assert.assertEquals((long)511L, (long)mode.toShort());
    }

    @Test
    public void toShort() {
        Mode mode = new Mode(Mode.Bits.ALL, Mode.Bits.READ_EXECUTE, Mode.Bits.READ_EXECUTE);
        Assert.assertEquals((long)493L, (long)mode.toShort());
        mode = Mode.defaults();
        Assert.assertEquals((long)511L, (long)mode.toShort());
        mode = new Mode(Mode.Bits.READ_WRITE, Mode.Bits.READ, Mode.Bits.READ);
        Assert.assertEquals((long)420L, (long)mode.toShort());
    }

    @Test
    public void fromShort() {
        Mode mode = new Mode(511);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOtherBits());
        mode = new Mode(420);
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)mode.getOtherBits());
        mode = new Mode(493);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getOtherBits());
    }

    @Test
    public void copyConstructor() {
        Mode mode = new Mode(Mode.defaults());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOtherBits());
        Assert.assertEquals((long)511L, (long)mode.toShort());
    }

    @Test
    public void createNoAccess() {
        Mode mode = Mode.createNoAccess();
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)mode.getOtherBits());
        Assert.assertEquals((long)0L, (long)mode.toShort());
    }

    @Test
    public void equals() {
        Mode allAccess = new Mode(511);
        Assert.assertTrue((boolean)allAccess.equals((Object)Mode.defaults()));
        Mode noAccess = new Mode(0);
        Assert.assertTrue((boolean)noAccess.equals((Object)Mode.createNoAccess()));
        Assert.assertFalse((boolean)allAccess.equals((Object)noAccess));
    }

    @Test
    public void toStringTest() {
        Assert.assertEquals((Object)"rwxrwxrwx", (Object)new Mode(511).toString());
        Assert.assertEquals((Object)"rw-r-----", (Object)new Mode(416).toString());
        Assert.assertEquals((Object)"rw-------", (Object)new Mode(384).toString());
        Assert.assertEquals((Object)"---------", (Object)new Mode(0).toString());
    }

    @Test
    public void applyUMask() {
        String umask = "0022";
        Mode mode = ModeUtils.applyDirectoryUMask((Mode)Mode.defaults(), (String)umask);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getOtherBits());
        Assert.assertEquals((long)493L, (long)mode.toShort());
    }

    @Test
    public void umask() {
        Assert.assertEquals((long)448L, (long)ModeUtils.getUMask((String)"0700").toShort());
        Assert.assertEquals((long)493L, (long)ModeUtils.getUMask((String)"0755").toShort());
        Assert.assertEquals((long)420L, (long)ModeUtils.getUMask((String)"0644").toShort());
    }

    @Test
    public void umaskExceedLength() {
        String umask = "00022";
        this.mConfiguration.set(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK, (Object)umask);
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_CONFIGURATION_VALUE.getMessage(new Object[]{umask, PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK}));
        ModeUtils.applyDirectoryUMask((Mode)Mode.defaults(), (String)this.mConfiguration.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
    }

    @Test
    public void umaskNotInteger() {
        String umask = "NotInteger";
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_CONFIGURATION_VALUE.getMessage(new Object[]{umask, PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK}));
        ModeUtils.applyDirectoryUMask((Mode)Mode.defaults(), (String)umask);
    }

    @Test
    public void setOwnerBits() {
        Mode mode = new Mode(0);
        mode.setOwnerBits(Mode.Bits.READ_EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getOwnerBits());
        mode.setOwnerBits(Mode.Bits.WRITE);
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)mode.getOwnerBits());
        mode.setOwnerBits(Mode.Bits.ALL);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOwnerBits());
    }

    @Test
    public void setGroupBits() {
        Mode mode = new Mode(0);
        mode.setGroupBits(Mode.Bits.READ_EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getGroupBits());
        mode.setGroupBits(Mode.Bits.WRITE);
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)mode.getGroupBits());
        mode.setGroupBits(Mode.Bits.ALL);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getGroupBits());
    }

    @Test
    public void setOtherBits() {
        Mode mode = new Mode(0);
        mode.setOtherBits(Mode.Bits.READ_EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)mode.getOtherBits());
        mode.setOtherBits(Mode.Bits.WRITE);
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)mode.getOtherBits());
        mode.setOtherBits(Mode.Bits.ALL);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)mode.getOtherBits());
    }
}

