/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.exception.ExceptionMessage;
import alluxio.security.authorization.Mode;
import alluxio.security.authorization.ModeParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class ModeParserTest {
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void numerics() {
        Mode parsed = ModeParser.parse((String)"777");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"755");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"644");
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getOtherBits());
    }

    @Test
    public void symbolicsSeparated() {
        Mode parsed = ModeParser.parse((String)"u=rwx,g=rwx,o=rwx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"u=rwx,g=rx,o=rx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"u=rw,g=r,o=r");
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getOtherBits());
    }

    @Test
    public void symbolicsCombined() {
        Mode parsed = ModeParser.parse((String)"a=rwx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"ugo=rwx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"u=rwx,go=rx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"u=rw,go=r");
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)parsed.getOtherBits());
    }

    @Test
    public void symbolicsCumulative() {
        Mode parsed = ModeParser.parse((String)"u=r,u=w,u=x");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"g=r,g=w,g=x");
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"o=r,o=w,o=x");
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOtherBits());
    }

    @Test
    public void symbolicsPartial() {
        Mode parsed = ModeParser.parse((String)"u=rwx");
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"go=rw");
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)parsed.getOtherBits());
        parsed = ModeParser.parse((String)"o=x");
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getOwnerBits());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)parsed.getGroupBits());
        Assert.assertEquals((Object)Mode.Bits.EXECUTE, (Object)parsed.getOtherBits());
    }

    @Test
    public void symbolicsBadEmpty() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE.getMessage(new Object[]{""}));
        ModeParser.parse((String)"");
    }

    @Test
    public void symbolicsBadNull() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE.getMessage(new Object[]{null}));
        ModeParser.parse(null);
    }

    @Test
    public void symbolicsBadWhitespace() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE.getMessage(new Object[]{"  "}));
        ModeParser.parse((String)"  ");
    }

    @Test
    public void symbolicsBadNoSeparator() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE_SEGMENT.getMessage(new Object[]{"u=rwx,foo", "foo"}));
        ModeParser.parse((String)"u=rwx,foo");
    }

    @Test
    public void symbolicsBadTargets() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE_SEGMENT.getMessage(new Object[]{"f=r", "f=r", "f"}));
        ModeParser.parse((String)"f=r");
    }

    @Test
    public void symbolicsBadPermissions() {
        this.mThrown.expect(IllegalArgumentException.class);
        this.mThrown.expectMessage(ExceptionMessage.INVALID_MODE_SEGMENT.getMessage(new Object[]{"u=Xst", "u=Xst", "Xst"}));
        ModeParser.parse((String)"u=Xst");
    }
}

