/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.Mode;
import org.junit.Assert;
import org.junit.Test;

public final class ModeBitsTest {
    @Test
    public void getSymbol() {
        Assert.assertEquals((Object)"---", (Object)Mode.Bits.NONE.toString());
        Assert.assertEquals((Object)"r--", (Object)Mode.Bits.READ.toString());
        Assert.assertEquals((Object)"-w-", (Object)Mode.Bits.WRITE.toString());
        Assert.assertEquals((Object)"--x", (Object)Mode.Bits.EXECUTE.toString());
        Assert.assertEquals((Object)"rw-", (Object)Mode.Bits.READ_WRITE.toString());
        Assert.assertEquals((Object)"r-x", (Object)Mode.Bits.READ_EXECUTE.toString());
        Assert.assertEquals((Object)"-wx", (Object)Mode.Bits.WRITE_EXECUTE.toString());
        Assert.assertEquals((Object)"rwx", (Object)Mode.Bits.ALL.toString());
    }

    @Test
    public void implies() {
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.READ));
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.WRITE));
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.EXECUTE));
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.READ_EXECUTE));
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.WRITE_EXECUTE));
        Assert.assertTrue((boolean)Mode.Bits.ALL.imply(Mode.Bits.ALL));
        Assert.assertTrue((boolean)Mode.Bits.READ_EXECUTE.imply(Mode.Bits.READ));
        Assert.assertTrue((boolean)Mode.Bits.READ_EXECUTE.imply(Mode.Bits.EXECUTE));
        Assert.assertFalse((boolean)Mode.Bits.READ_EXECUTE.imply(Mode.Bits.WRITE));
        Assert.assertTrue((boolean)Mode.Bits.WRITE_EXECUTE.imply(Mode.Bits.WRITE));
        Assert.assertTrue((boolean)Mode.Bits.WRITE_EXECUTE.imply(Mode.Bits.EXECUTE));
        Assert.assertFalse((boolean)Mode.Bits.WRITE_EXECUTE.imply(Mode.Bits.READ));
        Assert.assertTrue((boolean)Mode.Bits.READ_WRITE.imply(Mode.Bits.WRITE));
        Assert.assertTrue((boolean)Mode.Bits.READ_WRITE.imply(Mode.Bits.READ));
        Assert.assertFalse((boolean)Mode.Bits.READ_WRITE.imply(Mode.Bits.EXECUTE));
    }

    @Test
    public void notOperation() {
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)Mode.Bits.READ_EXECUTE.not());
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)Mode.Bits.WRITE_EXECUTE.not());
        Assert.assertEquals((Object)Mode.Bits.EXECUTE, (Object)Mode.Bits.READ_WRITE.not());
    }

    @Test
    public void orOperation() {
        Assert.assertEquals((Object)Mode.Bits.WRITE_EXECUTE, (Object)Mode.Bits.WRITE.or(Mode.Bits.EXECUTE));
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)Mode.Bits.READ.or(Mode.Bits.EXECUTE));
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)Mode.Bits.WRITE.or(Mode.Bits.READ));
    }

    @Test
    public void andOperation() {
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)Mode.Bits.READ.and(Mode.Bits.WRITE));
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)Mode.Bits.READ_EXECUTE.and(Mode.Bits.READ));
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)Mode.Bits.READ_WRITE.and(Mode.Bits.WRITE));
    }

    @Test
    public void toAclActions() {
        for (Mode.Bits bits : Mode.Bits.values()) {
            Assert.assertEquals((Object)bits, (Object)new AclActions(bits.toAclActionSet()).toModeBits());
        }
    }
}

