/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclEntry;
import org.junit.Assert;
import org.junit.Test;

public class AclEntryTest {
    @Test
    public void cliStringOwner() {
        this.checkCliString("user::---");
        this.checkCliString("user::--x");
        this.checkCliString("user::-w-");
        this.checkCliString("user::-wx");
        this.checkCliString("user::r--");
        this.checkCliString("user::r-x");
        this.checkCliString("user::rw-");
        this.checkCliString("user::rwx");
    }

    @Test
    public void cliStringNamedOwner() {
        this.checkCliString("user:a:---");
        this.checkCliString("user:b:r--");
        this.checkCliString("user:c:-w-");
        this.checkCliString("user:d:--x");
    }

    @Test
    public void cliStringOwningGroup() {
        this.checkCliString("group::---");
        this.checkCliString("group::r--");
        this.checkCliString("group::-w-");
        this.checkCliString("group::--x");
    }

    @Test
    public void cliStringNamedGroup() {
        this.checkCliString("group:a:---");
        this.checkCliString("group:b:r--");
        this.checkCliString("group:c:-w-");
        this.checkCliString("group:d:--x");
    }

    @Test
    public void cliStringMask() {
        this.checkCliString("mask::---");
        this.checkCliString("mask::r--");
        this.checkCliString("mask::-w-");
        this.checkCliString("mask::--x");
    }

    @Test
    public void cliStringOther() {
        this.checkCliString("other::---");
        this.checkCliString("other::r--");
        this.checkCliString("other::-w-");
        this.checkCliString("other::--x");
    }

    @Test
    public void cliStringDefault() {
        this.checkCliString("default:user::rwx");
        this.checkCliString("default:user:a:rwx");
        this.checkCliString("default:group::r--");
        this.checkCliString("default:group:b:-w-");
        this.checkCliString("default:mask::--x");
        this.checkCliString("default:other::---");
    }

    @Test
    public void cliStringInvalid() {
        this.checkCliStringInvalid(null);
        this.checkCliStringInvalid("");
        this.checkCliStringInvalid("::");
        this.checkCliStringInvalid("bad");
        this.checkCliStringInvalid("bad:bad:bad");
        this.checkCliStringInvalid("user::----");
        this.checkCliStringInvalid("user::r");
        this.checkCliStringInvalid("user::rrr");
        this.checkCliStringInvalid("group::----");
        this.checkCliStringInvalid("group::w");
        this.checkCliStringInvalid("group::www");
        this.checkCliStringInvalid("mask:mask:---");
        this.checkCliStringInvalid("other:other:---");
        this.checkCliStringInvalid("default:user:test");
    }

    private void checkCliString(String stringEntry) {
        AclEntry entry = AclEntry.fromCliString((String)stringEntry);
        String toString = entry.toCliString();
        Assert.assertEquals((Object)stringEntry, (Object)toString);
    }

    private void checkCliStringInvalid(String stringEntry) {
        try {
            this.checkCliString(stringEntry);
            Assert.fail((String)"this is expected to fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception");
        }
    }
}

