/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclActions;
import alluxio.security.authorization.Mode;
import org.junit.Assert;
import org.junit.Test;

public class AclActionsTest {
    @Test
    public void constructor() {
        AclActions actions = new AclActions();
        Assert.assertTrue((boolean)actions.getActions().isEmpty());
        AclActions copiedActions = new AclActions(actions);
        copiedActions.add(AclAction.READ);
        Assert.assertEquals((long)1L, (long)copiedActions.getActions().size());
        Assert.assertEquals((long)0L, (long)actions.getActions().size());
    }

    @Test
    public void toModeBits() {
        AclActions actions = new AclActions();
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.READ);
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.WRITE);
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.READ);
        actions.add(AclAction.WRITE);
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.READ);
        actions.add(AclAction.EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.WRITE);
        actions.add(AclAction.EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.WRITE_EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.add(AclAction.READ);
        actions.add(AclAction.WRITE);
        actions.add(AclAction.EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)actions.toModeBits());
    }

    @Test
    public void updateByModeBits() {
        AclActions actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.NONE);
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.READ);
        Assert.assertEquals((Object)Mode.Bits.READ, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.WRITE);
        Assert.assertEquals((Object)Mode.Bits.WRITE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.READ_WRITE);
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.READ_EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.READ_EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.WRITE_EXECUTE);
        Assert.assertEquals((Object)Mode.Bits.WRITE_EXECUTE, (Object)actions.toModeBits());
        actions = new AclActions();
        actions.updateByModeBits(Mode.Bits.ALL);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)actions.toModeBits());
    }

    @Test
    public void contains() {
        AclActions actions = new AclActions();
        Assert.assertFalse((boolean)actions.contains(AclAction.READ));
        Assert.assertFalse((boolean)actions.contains(AclAction.WRITE));
        Assert.assertFalse((boolean)actions.contains(AclAction.EXECUTE));
        actions.add(AclAction.READ);
        Assert.assertTrue((boolean)actions.contains(AclAction.READ));
        actions.add(AclAction.WRITE);
        Assert.assertTrue((boolean)actions.contains(AclAction.WRITE));
        actions.add(AclAction.EXECUTE);
        Assert.assertTrue((boolean)actions.contains(AclAction.EXECUTE));
    }

    @Test
    public void merge() {
        AclActions actions = new AclActions();
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)actions.toModeBits());
        actions.merge(new AclActions());
        Assert.assertEquals((Object)Mode.Bits.NONE, (Object)actions.toModeBits());
        AclActions readWrite = new AclActions();
        readWrite.add(AclAction.READ);
        readWrite.add(AclAction.WRITE);
        actions.merge(readWrite);
        Assert.assertEquals((Object)Mode.Bits.READ_WRITE, (Object)actions.toModeBits());
        AclActions execute = new AclActions();
        execute.add(AclAction.EXECUTE);
        actions.merge(execute);
        Assert.assertEquals((Object)Mode.Bits.ALL, (Object)actions.toModeBits());
    }
}

