/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.security.authorization.Mode;
import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AccessControlListTest {
    private static final String OWNING_USER = "owning_user";
    private static final String OWNING_GROUP = "owning_group";
    private static final String NAMED_USER = "named_user";
    private static final String NAMED_GROUP = "named_group";
    private static final String NAMED_GROUP2 = "named_group2";
    private static final String OTHER_USER = "other_user";
    private static final String OTHER_GROUP = "other_group";

    @Test
    public void constructor() {
        AccessControlList acl = new AccessControlList();
        Assert.assertEquals((Object)"", (Object)acl.getOwningUser());
        Assert.assertEquals((Object)"", (Object)acl.getOwningGroup());
    }

    @Test
    public void ownerGroup() {
        AccessControlList acl = new AccessControlList();
        acl.setOwningUser(OWNING_USER);
        acl.setOwningGroup(OWNING_GROUP);
        Assert.assertEquals((Object)OWNING_USER, (Object)acl.getOwningUser());
        Assert.assertEquals((Object)OWNING_GROUP, (Object)acl.getOwningGroup());
    }

    @Test
    public void actions() {
        AccessControlList acl = new AccessControlList();
        acl.setOwningUser(OWNING_USER);
        acl.setOwningGroup(OWNING_GROUP);
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_USER).setSubject(OWNING_USER).addAction(AclAction.READ).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_GROUP).setSubject(OWNING_GROUP).addAction(AclAction.READ).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OTHER).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(NAMED_USER).addAction(AclAction.READ).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(NAMED_GROUP).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
        acl.updateMask();
        Assert.assertTrue((boolean)this.checkMode(acl, OWNING_USER, Collections.emptyList(), Mode.Bits.ALL));
        Assert.assertTrue((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OWNING_GROUP}), Mode.Bits.READ_EXECUTE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OWNING_GROUP}), Mode.Bits.WRITE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Collections.emptyList(), Mode.Bits.READ));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Collections.emptyList(), Mode.Bits.WRITE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Collections.emptyList(), Mode.Bits.EXECUTE));
        Assert.assertTrue((boolean)this.checkMode(acl, NAMED_USER, Collections.emptyList(), Mode.Bits.ALL));
        Assert.assertTrue((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}), Mode.Bits.WRITE_EXECUTE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}), Mode.Bits.READ));
    }

    private boolean checkMode(AccessControlList acl, String user, List<String> groups, Mode.Bits mode) {
        for (AclAction action : mode.toAclActionSet()) {
            if (acl.checkPermission(user, groups, action)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void getMode() {
        AccessControlList acl = new AccessControlList();
        Assert.assertEquals((long)0L, (long)acl.getMode());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_USER).setSubject(OWNING_USER).addAction(AclAction.READ).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_GROUP).setSubject(OWNING_GROUP).addAction(AclAction.WRITE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OTHER).addAction(AclAction.EXECUTE).build());
        Assert.assertEquals((long)new Mode(Mode.Bits.READ, Mode.Bits.WRITE, Mode.Bits.EXECUTE).toShort(), (long)acl.getMode());
    }

    @Test
    public void setMode() {
        AccessControlList acl = new AccessControlList();
        short mode = new Mode(Mode.Bits.EXECUTE, Mode.Bits.WRITE, Mode.Bits.READ).toShort();
        acl.setMode(mode);
        Assert.assertEquals((long)mode, (long)acl.getMode());
    }

    private void setPermissions(AccessControlList acl) {
        acl.setOwningUser(OWNING_USER);
        acl.setOwningGroup(OWNING_GROUP);
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_USER).setSubject(OWNING_USER).addAction(AclAction.READ).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OWNING_GROUP).setSubject(OWNING_GROUP).addAction(AclAction.READ).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.OTHER).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.NAMED_USER).setSubject(NAMED_USER).addAction(AclAction.READ).addAction(AclAction.EXECUTE).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(NAMED_GROUP).addAction(AclAction.READ).build());
        acl.setEntry(new AclEntry.Builder().setType(AclEntryType.NAMED_GROUP).setSubject(NAMED_GROUP2).addAction(AclAction.WRITE).addAction(AclAction.EXECUTE).build());
        acl.updateMask();
    }

    @Test
    public void checkPermission() {
        AccessControlList acl = new AccessControlList();
        this.setPermissions(acl);
        Assert.assertTrue((boolean)this.checkMode(acl, OWNING_USER, Collections.emptyList(), Mode.Bits.ALL));
        Assert.assertTrue((boolean)this.checkMode(acl, NAMED_USER, Collections.emptyList(), Mode.Bits.READ_EXECUTE));
        Assert.assertFalse((boolean)this.checkMode(acl, NAMED_USER, Collections.emptyList(), Mode.Bits.WRITE));
        Assert.assertTrue((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OWNING_GROUP}), Mode.Bits.READ_EXECUTE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OWNING_GROUP}), Mode.Bits.WRITE));
        Assert.assertTrue((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}), Mode.Bits.READ));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}), Mode.Bits.WRITE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}), Mode.Bits.EXECUTE));
        Assert.assertTrue((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OTHER_GROUP}), Mode.Bits.EXECUTE));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OTHER_GROUP}), Mode.Bits.READ));
        Assert.assertFalse((boolean)this.checkMode(acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OTHER_GROUP}), Mode.Bits.WRITE));
    }

    private void assertMode(Mode.Bits expected, AccessControlList acl, String user, List<String> groups) {
        Assert.assertEquals((Object)expected, (Object)acl.getPermission(user, groups).toModeBits());
    }

    @Test
    public void getPermission() {
        AccessControlList acl = new AccessControlList();
        this.setPermissions(acl);
        this.assertMode(Mode.Bits.ALL, acl, OWNING_USER, Collections.emptyList());
        this.assertMode(Mode.Bits.READ_EXECUTE, acl, NAMED_USER, Collections.emptyList());
        this.assertMode(Mode.Bits.READ_EXECUTE, acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OWNING_GROUP}));
        this.assertMode(Mode.Bits.READ, acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP}));
        this.assertMode(Mode.Bits.WRITE_EXECUTE, acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP2}));
        this.assertMode(Mode.Bits.ALL, acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{NAMED_GROUP, NAMED_GROUP2}));
        this.assertMode(Mode.Bits.EXECUTE, acl, OTHER_USER, Collections.emptyList());
        this.assertMode(Mode.Bits.EXECUTE, acl, OTHER_USER, Lists.newArrayList((Object[])new String[]{OTHER_GROUP}));
    }

    @Test
    public void checkEquals() {
        AccessControlList a1 = new AccessControlList();
        a1.setOwningUser("test1");
        DefaultAccessControlList a2 = new DefaultAccessControlList();
        a2.setOwningUser("test2");
        new EqualsTester().addEqualityGroup(new Object[]{new DefaultAccessControlList(), new DefaultAccessControlList()}).addEqualityGroup(new Object[]{new AccessControlList(), new AccessControlList()}).addEqualityGroup(new Object[]{a1}).addEqualityGroup(new Object[]{a2}).testEquals();
    }
}

