/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.ConfigurationTestUtils;
import alluxio.conf.AlluxioConfiguration;
import alluxio.exception.status.UnauthenticatedException;
import alluxio.security.authentication.plain.SaslClientHandlerPlain;
import javax.security.auth.Subject;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SaslHandlersTest {
    private AlluxioConfiguration mConfiguration = ConfigurationTestUtils.defaults();
    @Rule
    public ExpectedException mThrown = ExpectedException.none();

    @Test
    public void testCreateClientSimpleNullSubject() throws UnauthenticatedException {
        this.mThrown.expect(UnauthenticatedException.class);
        this.mThrown.expectMessage("client subject not provided");
        SaslClientHandlerPlain client = new SaslClientHandlerPlain(null, this.mConfiguration);
    }

    @Test
    public void testCreateClientSimpleEmptySubject() throws UnauthenticatedException {
        this.mThrown.expect(UnauthenticatedException.class);
        this.mThrown.expectMessage("PLAIN: authorization ID and password must be specified");
        SaslClientHandlerPlain client = new SaslClientHandlerPlain(new Subject(), this.mConfiguration);
    }

    @Test
    public void testCreateClientSimpleNullUser() throws UnauthenticatedException {
        this.mThrown.expect(UnauthenticatedException.class);
        this.mThrown.expectMessage("PLAIN: authorization ID and password must be specified");
        SaslClientHandlerPlain client = new SaslClientHandlerPlain(null, null, null);
    }

    @Test
    public void testCreateClientSimpleNullPasword() throws UnauthenticatedException {
        this.mThrown.expect(UnauthenticatedException.class);
        this.mThrown.expectMessage("PLAIN: authorization ID and password must be specified");
        SaslClientHandlerPlain client = new SaslClientHandlerPlain("test", null, null);
    }
}

